/**
 * File : editUser.js 
 * 
 * This file contain the validation of edit user form
 * 
 * @author Vijayraj Chaudhary
 */
$(document).ready(function(){
	

	//$('#shift_div').css('display', 'none');


    $('#role').on('change', function() {

        if ($(this).val() === '4') {

            $('#shift_div').css('display', 'block');
        } else {

            $('#shift_div').css('display', 'none');
        }
    });


	var editUserForm = $("#editUser");
	
	var validator = editUserForm.validate({
		
		rules:{
			fname :{ required : true },
			email : { required : true, email : true, remote : { url : baseURL + "checkEmailExists", type :"post", data : { userId : function(){ return $("#userId").val(); } } } },
			cpassword : {equalTo: "#password"},
			mobile : { required : true, digits : true ,maxlength:10,minlength:10},
			role : { required : true, selected : true},
			emp_code: { required : true , remote : { url : baseURL + "checkEmployeecode", type :"post", data : { userId : function(){ return $("#userId").val(); } } } },
            doj: { required : true},
           
		},
		messages:{
			fname :{ required : "Please enter the full name" },
			email : { required : "This field is required", email : "Please enter valid email address", remote : "Email already taken" },
			cpassword : {equalTo: "Please enter same password" },
			mobile : { required : "This field is required", digits : "Please enter numbers only" },
			role : { required : "Please select the role", selected : "Please select atleast one option" },
            emp_code : { required : "Please enter the employee code", remote : "Employee code already taken"},
            
            doj : { required : "Please select the date of joining" }	
		}
	});

	var editProfileForm = $("#editProfile");
	
	var validator = editProfileForm.validate({
		
		rules:{
			fname :{ required : true },
			mobile : { required : true, digits : true },
		},
		messages:{
			fname :{ required : "This field is required" },
			mobile : { required : "This field is required", digits : "Please enter numbers only" },
		}
	});

});