<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1><i class="fa fa-ticket"></i> Tickets </h1>
  </section>

  <section class="content">
    <?php
    $this->load->helper('form');
    $error = $this->session->flashdata('error');
    if ($error) {
      ?>
      <div class="alert alert-danger alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
        <?php echo $this->session->flashdata('error'); ?>
      </div>
    <?php } ?>
    <?php
    $success = $this->session->flashdata('success');
    if ($success) {
      ?>
      <div class="alert alert-success alert-dismissable">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
        <?php echo $this->session->flashdata('success'); ?>
      </div>
    <?php } ?>
    <div class="row">
      <div class="col-md-12">
        <div class="form-group text-right">
          <button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#addnew">Add New<?php echo $this->role; ?></button>
        </div>
      </div>
    </div>
    <?php if ($role == '1') { ?>
      <form action="javascript:void(0)" onsubmit="showTicketFilter()">
        <div class="row">
          <div class="col-md-3">
            <div class="form-group">
              <label>Ticket ID</label>
              <input type="text" name="filter_ticket_id" id="filter_ticket_id" value="" class="form-control" placeholder=""/>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label>Subject</label>
              <input type="text" name="filter_ticket_subject" id="filter_ticket_subject" value="" class="form-control" placeholder=""/>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label>Assign to</label>
              <select class="form-control" name="filter_ticket_assign" id="filter_ticket_assign">
              </select>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label>Email</label>
              <input type="text" name="filter_ticket_email" id="filter_ticket_email" value="" class="form-control" placeholder=""/>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label>Start Date</label>
              <input type="text" autocomplete="off" name="filter_ticket_start_date" onkeypress="return false" id="filter_ticket_start_date" value="" class="form-control" placeholder=""/>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label>Due Date</label>
              <input type="text"  autocomplete="off" name="filter_ticket_due_date" onkeypress="return false" id="filter_ticket_due_date" value="" class="form-control" placeholder=""/>
            </div>
          </div>
          <div class="col-md-3">
            <div class="form-group">
              <label>Priority</label>
              <select class="form-control" name="filter_ticket_priority" id="filter_ticket_priority">
                <option value="">-- Select --</option>
                <option value="Low">Low</option>
                <option value="Normal">Normal</option>
                <option value="High">High</option>
                <option value="Very High">Very High</option>
              </select>
            </div>
          </div>
          <div class="col-md-3">
            <button type="submit" class="btn btn-primary searchList mt25"><i class="fa fa-search"></i> Search</button>
            <button class="btn btn-default searchList mt25" type="reset" onclick="window.location.replace('<?php echo site_url('support-tickets') ?>')"><i class="fa fa-refresh"></i> Reset</button>
          </div>
        </div>
      </form>
      <hr>
    <?php } ?>

    <div class="row">
      <div class="col-xs-12 ticket-page">
        <h3 class="box-title">Tickets List</h3>
        <ul class="nav nav-tabs">
          <li class="active"><a data-toggle="tab" href="#all">All (<?php echo $allTicket; ?>)</a></li>
          <li><a data-toggle="tab" href="#open">Open (<?php echo $openTicket; ?>)</a></li>
          <li><a data-toggle="tab" href="#closed">Closed (<?php echo $closeTicket; ?>)</a></li>
        </ul>

        <div class="tab-content">
          <div id="all" class="tab-pane fade in active">
            <table class="table table-striped listingtable" id="allticketlisting">
              <thead>
                <tr class="listingtable-head">
                  <th>Subject</th>
                  <th>Priority</th>
                  <th>Ticket ID</th>
                  <th>Answered</th>
                  <th>Status</th>
                  <th>Due Date</th>
                  <th>&nbsp;</th>
                </tr>
              </thead>
              <tbody>


              </tbody>
            </table>
          </div>
          <div id="open" class="tab-pane fade">
            <table class="table table-striped listingtable" id="openticketlisting">
              <thead>
                <tr class="listingtable-head">
                  <th>Subject</th>
                  <th>Priority</th>
                  <th>Ticket ID</th>
                  <th>Answered</th>
                  <th>Status</th>
                  <th>Due Date</th>
                  <th>&nbsp;</th>
                </tr>
              </thead>
              <tbody>
                <!-- Start -->
                <tr class="odd">
                  <td>Enable Customer Registration Form 1<br>
                    <b>Assign to</b> Manoj<br>
                    <b>Assignee</b> Shiv
                  </td>
                  <td><span class="label label-low">Low</span></td>
                  <td>#T0001</td>
                  <td><b>Last Reply:</b> 02/12/2018</td>
                  <td><span class="label label-new">New</span></td>
                  <td>10/12/2018</td>
                  <td align="right"><a href="<?php echo site_url('view-tickets') ?>" class="btn btn-default">View</a> &nbsp; <button type="button" class="btn btn-danger">Delete</button></td>
                </tr>
                <!-- End -->
                <tr class="odd">
                  <td>Test 1<br>
                    <b>Assign to</b> Manoj<br>
                    <b>Assignee</b> Shiv
                  </td>
                  <td><span class="label label-normal">Normal</span></td>
                  <td>#T0002</td>
                  <td><b>Last Reply:</b> 02/12/2018</td>
                  <td><span class="label label-inprogress">In Progress</span></td>
                  <td>10/12/2018</td>
                  <td align="right"><a href="<?php echo site_url('view-tickets') ?>" class="btn btn-default">View</a> &nbsp; <button type="button" class="btn btn-danger">Delete</button></td>
                </tr>
                <!-- End -->
                <tr class="odd">
                  <td>Test 1<br>
                    <b>Assign to</b> Manoj<br>
                    <b>Assignee</b> Shiv
                  </td>
                  <td><span class="label label-high">High</span></td>
                  <td>#T0003</td>
                  <td><b>Last Reply:</b> 02/12/2018</td>
                  <td><span class="label label-pending">Pending</span></td>
                  <td>10/12/2018</td>
                  <td align="right"><a href="<?php echo site_url('view-tickets') ?>" class="btn btn-default">View</a> &nbsp; <button type="button" class="btn btn-danger">Delete</button></td>
                </tr>
                <!-- End -->
                <tr class="odd">
                  <td>Test 1<br>
                    <b>Assign to</b> Manoj<br>
                    <b>Assignee</b> Shiv
                  </td>
                  <td><span class="label label-veryhigh">Very High</span></td>
                  <td>#T0004</td>
                  <td><b>Last Reply:</b> 02/12/2018</td>
                  <td><span class="label label-missing">Missing Info</span></td>
                  <td>10/12/2018</td>
                  <td align="right"><a href="<?php echo site_url('view-tickets') ?>" class="btn btn-default">View</a> &nbsp; <button type="button" class="btn btn-danger">Delete</button></td>
                </tr>
              </tbody>
            </table>
          </div>
          <div id="closed" class="tab-pane fade">
            <table class="table table-striped listingtable" id="closeticketlisting">
              <thead>
                <tr class="listingtable-head">
                  <th>Subject</th>
                  <th>Priority</th>
                  <th>Ticket ID</th>
                  <th>Answered</th>
                  <th>Status</th>
                  <th>Due Date</th>
                  <th>&nbsp;</th>
                </tr>
              </thead>
              <tbody>
                <!-- Start -->
                <tr class="odd">
                  <td>Test 1<br>
                    <b>Assign to</b> Manoj<br>
                    <b>Assignee</b> Shiv
                  </td>
                  <td><span class="label label-normal">Normal</span></td>
                  <td>#T0005</td>
                  <td><b>Last Reply:</b> 02/12/2018</td>
                  <td><span class="label label-complete">Closed</span></td>
                  <td>10/12/2018</td>
                  <td align="right"><a href="<?php echo site_url('view-tickets') ?>" class="btn btn-default">View</a> &nbsp; <button type="button" class="btn btn-danger">Delete</button></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>


      </div>
    </div>
  </section>


  <div id="addnew" class="modal fade" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">

      <!-- Modal content-->
      <form action="" enctype="multipart/form-data" name="employeeTicketForm" id="employeeTicketForm" >
        <div class="modal-content" >
          <div class="modal-header listingtable-head">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">New Ticket</h4>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Subject <span class="red">*</span></label>
                  <input type="text" name="ticketsubject" id="ticketsubject" value="" class="form-control" required placeholder=""/>
                </div>
              </div>


              <div class="col-md-6">
                <div class="form-group">
                  <label>Warehouse <span class="red">*</span></label>

                  <select name="warehouse" id="warehouse" class="form-control"  onchange = "getDepartment(this)" required  style="width: 100%">
                    <?php if (!empty($warehouseList)) { ?>
                      <?php foreach ($warehouseList as $org) { ?>
                        <option value="<?php echo $org['id']; ?>"><?php echo $org['org_name'] ?></option>
                      <?php } ?>
                    <?php } ?>
                  </select>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label>Department <span class="red">*</span></label>
                  <select onchange="showDepartmentEmployee(this.value)" class="form-control" id="department_id" name="departmentId" required>
                    <option value="">Select Department</option>
                    <?php if (!empty($departmentList)) { ?>
                      <?php foreach ($departmentList as $dept) { ?>
                        <?php if ($role == '1' || $role == '8') { ?>
                          <option value="<?php echo $dept['dept_id']; ?>"><?php echo $dept['dept_name']; ?></option>
                        <?php } else { //if($department_id == $dept['dept_id']) continue; ?>
                          <option value="<?php echo $dept['dept_id']; ?>"><?php echo $dept['dept_name']; ?></option>
                        <?php } ?>
                      <?php } ?>
                    <?php } ?>
                  </select>
                </div>
              </div>


              <div class="col-md-6">
                <div class="form-group">
                  <label>Assign to <span class="red">*</span></label>

                  <select name="ticketassignto[]" id="ticketassigntonew" class="form-control" required multiple="multiple" style="width: 100%">
                  </select>
                </div>
              </div>





              <div class="col-md-6">
                <div class="form-group">
                  <label>Start Date <span class="red">*</span></label>
                  <input type="text" autocomplete="off" name="ticketstartdate" id="ticketstartdate" onkeypress="return false" value="" class="form-control" placeholder=""/>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Due Date <span class="red">*</span></label>
                  <input type="text" autocomplete="off" name="ticketduedate" id="ticketduedate" value="" onkeypress="return false" class="form-control" placeholder=""/>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Priority <span class="red">*</span></label>
                  <select class="form-control" name="ticketpriority" id="ticketpriority" required>
                    <option value="">-- Select --</option>
                    <option value="Low">Low</option>
                    <option value="Normal">Normal</option>
                    <option value="High">High</option>
                    <option value="Very High">Very High</option>
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Attach File <button type="button" onclick="addattachmentfiles()" class="btn btn-primary btn-xs">Add more</button></label>
                  <div class="ticketfilesection">
                    <input accept=".csv,.xls,.txt,.pdf,.docx,.xlsx,image/*" type="file" name="ticketfile[]" id="ticketpriority" />
                  </div>
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-group">
                  <label>Description <span class="red">*</span></label>
                  <textarea required name="ticketdescription" id="ticketdescription" cols="" rows="6" class="form-control"></textarea>
                </div>
              </div>
              <div class="col-md-12">
                <button type="submit" onclick="tinyMCE.triggerSave(true, true);" class="btn btn-primary searchList">Submit</button>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>





  <div id="editticketform" class="modal fade" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">

      <!-- Modal content-->
      <form action="" enctype="multipart/form-data" name="editticketform" id="editemployeeticketform" >
        <div class="modal-content" >
          <div class="modal-header listingtable-head">
            <button type="button" class="close" data-dismiss="modal">&times;</button>
            <h4 class="modal-title">Edit Ticket</h4>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label>Subject <span class="red">*</span></label>
                  <input type="text" name="editticketsubject" id="editticketsubject" value="" class="form-control" required placeholder=""/>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Assign to <span class="red">*</span></label>
                  <!-- <input type="text" name="ticketassignto" id="ticketassignto" value="" class="form-control" required placeholder=""/> -->
                  <select name="editticketassignto[]" id="editticketassignto" class="form-control" required multiple="multiple" style="width: 100%">
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Start Date <span class="red">*</span></label>
                  <input type="text" autocomplete="off" name="editticketstartdate" id="editticketstartdate" onkeypress="return false" value="" class="form-control" placeholder=""/>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Due Date <span class="red">*</span></label>
                  <input type="text" autocomplete="off" name="editticketduedate" id="editticketduedate" value="" onkeypress="return false" class="form-control" placeholder=""/>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Priority <span class="red">*</span></label>
                  <select class="form-control" name="editticketpriority" id="editticketpriority" required>
                    <option value="">-- Select --</option>
                    <option value="Low">Low</option>
                    <option value="Normal">Normal</option>
                    <option value="High">High</option>
                    <option value="Very High">Very High</option>
                  </select>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label>Attach File <button type="button" onclick="editattachmentfiles()" class="btn btn-primary btn-xs">Add more</button></label>
                  <div class="oldfiles"></div>
                  <div class="editticketfilesection">
                    <input accept=".csv,.xls,.xlsx,image/*" type="file" name="editticketfile[]" id="ticketpriority" />
                  </div>
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-group">
                  <label>Description <span class="red">*</span></label>
                  <textarea required name="editticketdescription" id="editticketdescription" cols="" rows="6" class="form-control"></textarea>
                </div>
              </div>
              <div class="col-md-12">
                <button type="submit" onclick="tinyMCE.triggerSave(true, true);" class="btn btn-primary searchList">Update</button>
                <input type="hidden" name="editticketId" id="editticketId" value="">
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>

<!--<section class="content-header">
      <h1><i class="fa fa-ticket"></i> New Ticket</h1>
    </section>
    <form>
    <section class="content">
        <div class="row">
        <div class="col-md-6">
         <div class="form-group">
          <label>Subject <span class="red">*</span></label>
          <input type="text" name="" id="" value="" class="form-control" placeholder=""/>
         </div>
        </div>
        <div class="col-md-6">
         <div class="form-group">
          <label>Assign to <span class="red">*</span></label>
          <input type="text" name="" id="" value="" class="form-control" placeholder=""/>
         </div>
        </div>
        <div class="col-md-6">
         <div class="form-group">
          <label>Start Date <span class="red">*</span></label>
          <input type="text" name="" id="" value="" class="form-control" placeholder=""/>
         </div>
        </div>
        <div class="col-md-6">
         <div class="form-group">
          <label>Due Date <span class="red">*</span></label>
          <input type="text" name="" id="" value="" class="form-control" placeholder=""/>
         </div>
        </div>
        <div class="col-md-6">
         <div class="form-group">
          <label>Priority <span class="red">*</span></label>
          <select class="form-control">
            <option>-- Select --</option>
            <option>Low</option>
            <option>Normal</option>
            <option>High</option>
            <option>Very High</option>
          </select>
         </div>
        </div>
        <div class="col-md-6">
         <div class="form-group">
          <label>Attach File</label>
          <input type="file" /></div>
         </div>
        <div class="col-md-12">
         <div class="form-group">
          <label>Description <span class="red">*</span></label>
          <textarea cols="" rows="6" class="form-control"></textarea>
         </div>
        </div>
        </div>
        <div class="col-md-12">
         <button class="btn btn-primary searchList">Submit</button>
        </div>
        </div>
    </section>
    </form>
  -->






</div>
<script>


  $("#filter_ticket_assign").select2({
  });
  $("#filter_ticket_priority").select2({
  });
  $("#warehouse").select2({
  });
  $("#department_id").select2({
  });
  $("#rackaisle").select2({
  });
  $("#ticketassigntonew").select2({
  });
  $("#floorprocessingarea").select2({
  });
  $("#ticketpriority").select2({
  });
  $("#editticketassignto").select2({
  });
  $("#editticketpriority").select2({
  });

</script>
