<?php
$userId = $userInfo->userId;
$name = $userInfo->name;
$email = $userInfo->email;
$mobile = $userInfo->mobile;
$roleId = $userInfo->roleId;
$role = $userInfo->role;
$avatar = $userInfo->avatar;
$skills = $userInfo->skills;
?>

<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      <i class="fa fa-user-circle"></i> My Profile
      <small>View or modify information</small>
    </h1>
  </section>

  <section class="content">

    <div class="row">
      <!-- left column -->
      <div class="col-md-3">
        <!-- general form elements -->


        <div class="box box-warning">
          <div class="box-body box-profile">

<?php if ($avatar != '' && file_exists(FCPATH . '/assets/images/avatar/' . $avatar)) { ?>
              <img class="profile-user-img img-responsive img-circle" src="<?php echo base_url('/assets/images/avatar/' . $avatar); ?>" alt="User profile picture">
            <?php } else { ?>
              <img class="profile-user-img img-responsive img-circle" src="<?php echo base_url(); ?>assets/dist/img/avatar.png" alt="User profile picture">
            <?php } ?>
            <h3 class="profile-username text-center"><?= $name ?></h3>

            <p class="text-muted text-center"><?= $designation ?></p>

            <ul class="list-group list-group-unbordered">
              <li class="list-group-item">
                <b>Email</b> <a class="pull-right"><?= $email ?></a>
              </li>
              <li class="list-group-item">
                <b>Mobile</b> <a class="pull-right"><?= $mobile ?></a>
              </li>
            </ul>
          </div>
        </div>

      </div>

      <div class="col-md-5">
        <div class="nav-tabs-custom">
          <ul class="nav nav-tabs">
            <li class="<?= ($active == "details") ? "active" : "" ?>"><a href="#details" data-toggle="tab">Details</a></li>
            <li class="<?= ($active == "changepass") ? "active" : "" ?>"><a href="#changepass" data-toggle="tab">Change Password</a></li>
          </ul>
          <div class="tab-content">
            <div class="<?= ($active == "details") ? "active" : "" ?> tab-pane" id="details">
              <form action="<?php echo base_url() ?>profileUpdate" method="post" id="editProfile" role="form" enctype="multipart/form-data">
<?php $this->load->helper('form'); ?>
                <div class="box-body">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="fname">Full Name</label>
                        <input type="text" class="form-control" id="fname" name="fname" placeholder="<?php echo $name; ?>" value="<?php echo set_value('fname', $name); ?>" maxlength="128" />
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="mobile">Mobile No.</label>
                        <input type="text" class="form-control" id="mobile" name="mobile" placeholder="<?php echo $mobile; ?>" value="<?php echo set_value('mobile', $mobile); ?>" maxlength="10">
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="mobile">Profile Pic</label>
                        <input type="file" accept="image/*" class="form-control" id="avatar" name="avatar">
                      </div>
                    </div>
                  </div>
                </div><!-- /.box-body -->
                <div class="box-footer">
                  <input type="submit" class="btn btn-primary" value="Submit" />
                  <input type="reset" class="btn btn-default" value="Reset" />
                </div>
              </form>
            </div>
            <div class="<?= ($active == "changepass") ? "active" : "" ?> tab-pane" id="changepass">
              <form role="form" action="<?php echo base_url() ?>changePassword" method="post">
                <div class="box-body">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="inputPassword1">Old Password</label>
                        <input type="password" class="form-control" id="inputOldPassword" placeholder="Old password" name="oldPassword" maxlength="20" required>
                      </div>
                    </div>
                  </div>
                  <hr>
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="inputPassword1">New Password</label>
                        <input type="password" class="form-control" id="inputPassword1" placeholder="New password" name="newPassword" maxlength="20" required>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label for="inputPassword2">Confirm New Password</label>
                        <input type="password" class="form-control" id="inputPassword2" placeholder="Confirm new password" name="cNewPassword" maxlength="20" required>
                      </div>
                    </div>
                  </div>
                </div><!-- /.box-body -->

                <div class="box-footer">
                  <input type="submit" class="btn btn-primary" value="Submit" />
                  <input type="reset" class="btn btn-default" value="Reset" />
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
      <div class="col-md-4">
<?php
$this->load->helper('form');
$error = $this->session->flashdata('error');
if ($error) {
  ?>
          <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
          <?php echo $this->session->flashdata('error'); ?>
          </div>
          <?php } ?>
          <?php
          $success = $this->session->flashdata('success');
          if ($success) {
            ?>
          <div class="alert alert-success alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
          <?php echo $this->session->flashdata('success'); ?>
          </div>
<?php } ?>

          <?php
          $noMatch = $this->session->flashdata('nomatch');
          if ($noMatch) {
            ?>
          <div class="alert alert-warning alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
          <?php echo $this->session->flashdata('nomatch'); ?>
          </div>
        <?php } ?>

        <div class="row">
          <div class="col-md-12">
        <?php echo validation_errors('<div class="alert alert-danger alert-dismissable">', ' <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button></div>'); ?>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<script src="<?php echo base_url(); ?>assets/js/editUser.js" type="text/javascript"></script>