<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

/**
 * Class : User_model (User Model)
 * User model class to get to handle user related data
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 15 November 2019
 */
class User_model extends CI_Model {

  /**
   * This function is used to get the user listing count
   * @param string $searchText : This is optional search text
   * @return number $count : This is row count
   */
  function userListingCount($searchText = '', $empCode = '', $emailId = '', $organizationId = '', $deptId = '') {
    $this->db->select('BaseTbl.userId, BaseTbl.email, BaseTbl.name, BaseTbl.mobile, BaseTbl.createdDtm, Role.role,BaseTbl.skills,BaseTbl.emp_code,BaseTbl.doj,BaseTbl.reporting_manager');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->join('tbl_roles as Role', 'Role.roleId = BaseTbl.roleId', 'left');
    if ($fOrganizationId != '') {
      $this->db->where('BaseTbl.organization_id', $fOrganizationId);
    }
    if ($deptId != '') {
      $this->db->where('BaseTbl.department_id', $deptId);
    }
    if ($emailId != '') {
      $searchText = $emailId;
    }
    if (!empty($searchText)) {
      $likeCriteria = "(BaseTbl.email  LIKE '%" . $searchText . "%'
                            OR  BaseTbl.name  LIKE '%" . $searchText . "%'
                            OR  BaseTbl.mobile  LIKE '%" . $searchText . "%')";
      $this->db->where($likeCriteria);
    }
    if (!empty($empCode)) {
      $likeCriteria = "(BaseTbl.emp_id  LIKE '%" . $empCode . "%')";
      $this->db->or_where($likeCriteria);
    }

    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->where('BaseTbl.roleId =', 3);
    $query = $this->db->get();

    return $query->num_rows();
  }

  function userAllUsersByRole($role) {
    $this->db->select('BaseTbl.*');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->where('BaseTbl.roleId =', $role);
    $query = $this->db->get();
    return $query->num_rows();
  }

  function deleteUserListing() {

    $this->db->where('BaseTbl.isDeleted', '0');
    $this->db->select('count(BaseTbl.userId) as totalUser,BaseTbl.excel_id,DATE_FORMAT(createdDtm, "%d/%l/%Y")');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->where('BaseTbl.excel_id !=', '');
    $this->db->group_by('BaseTbl.excel_id', 'DESC');
    $this->db->limit($page, $segment);
    $query = $this->db->get();
    $result = $query->result();
    //pre($result);
    return $result;
  }

  function getUserName($userId) {
    $this->db->select('name');
    $this->db->where('userId', $userId);
    $result = $this->db->get('tbl_users')->row_array();
    if (isset($result['name'])) {
      return ucfirst($result['name']);
    } else {
      return '';
    }
  }

  function getTicketAssign($ticketNumber) {
    $result = $this->db->query("SELECT name,GROUP_CONCAT(name SEPARATOR ', ') as groupname FROM tbl_users WHERE userId IN (SELECT assign_user FROM tbl_ticket_assign_user WHERE ticket_no = '" . $ticketNumber . "')")->result_array();

    if (isset($result[0]['groupname'])) {
      return $result[0]['groupname'];
    } else {
      return '';
    }
  }

  /**
   * This function is used to get the user listing count
   * @param string $searchText : This is optional search text
   * @param number $page : This is pagination offset
   * @param number $segment : This is pagination limit
   * @return array $result : This is result
   */
  function userListing($searchText = '', $page, $segment, $empcode = '', $emailId = '', $fOrganizationId = '', $deptId = '', $roleId = '') {
    //echo $roleId;
    //die;
    $this->db->select('BaseTbl.userId,BaseTbl.emp_id,organization.org_name,dpt.dept_name,BaseTbl.email, BaseTbl.name, BaseTbl.mobile, BaseTbl.createdDtm, Role.role,BaseTbl.emp_id,BaseTbl.designation,BaseTbl.skills,BaseTbl.emp_code,BaseTbl.doj,BaseTbl.reporting_manager,reptmng.name reporting_manager_name');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->join('tbl_roles as Role', 'Role.roleId = BaseTbl.roleId', 'left');
    $this->db->join('tbl_organization as organization', 'organization.id = BaseTbl.organization_id');
    $this->db->join('tbl_departments as dpt', 'dpt.dept_id = BaseTbl.department_id');
    $this->db->join('tbl_users as reptmng', 'reptmng.userId = BaseTbl.reporting_manager', 'LEFT');
    if ($fOrganizationId != '') {
      $this->db->where('BaseTbl.organization_id', $fOrganizationId);
    }
    if ($deptId != '') {
      $this->db->where('BaseTbl.main_dept_id', $deptId);
    }
    if ($roleId != '') {
      $this->db->where('BaseTbl.roleId', $roleId);
    }
    if ($emailId != '') {
      $searchText = $emailId;
    }
    if (!empty($searchText)) {
      $likeCriteria = "(BaseTbl.email  LIKE '%" . $searchText . "%'
                            OR  BaseTbl.name  LIKE '%" . $searchText . "%'
                            OR  BaseTbl.mobile  LIKE '%" . $searchText . "%')";
      $this->db->where($likeCriteria);
    }
    if (!empty($empCode)) {
      $likeCriteria = "(BaseTbl.emp_id  LIKE '%" . $empCode . "%')";
      $this->db->or_where($likeCriteria);
    }
    $this->db->where('BaseTbl.isDeleted', 0);
    $this->db->where('BaseTbl.roleId !=', 1);
    $this->db->order_by('BaseTbl.userId', 'DESC');
    $this->db->limit($page, $segment);
    $query = $this->db->get();

    $result = $query->result();
    //pre($result);
    //echo $this->db->last_query();
    //die;
    return $result;
  }

  function locationList() {
    $this->db->where('isDeleted', '0');
    $this->db->select('tbl_location.*');
//    $this->db->join('tbl_clients', 'tbl_location.client_id=tbl_clients.id');
    return $locationList = $this->db->get('tbl_location')->result_array();
  }

  /**
   * This function is used to get the user roles information
   * @return array $result : This is result of the query
   */
  function getUserRoles() {
    $this->db->select('roleId, role');
    $this->db->from('tbl_roles');
    $this->db->where('roleId !=', 1);
    $query = $this->db->get();

    return $query->result();
  }

  /**
   * This function is used to check whether email id is already exist or not
   * @param {string} $email : This is email id
   * @param {number} $userId : This is user id
   * @return {mixed} $result : This is searched result
   */
  function checkEmailExists($email, $userId = 0) {
    $this->db->select("email");
    $this->db->from("tbl_users");
    $this->db->where("email", $email);
    $this->db->where("isDeleted", 0);
    if ($userId != 0) {
      $this->db->where("userId !=", $userId);
    }
    $query = $this->db->get();

    return $query->result();
  }

  function checkEmployeecode($empcode, $userId = 0) {
    $this->db->select("emp_code");
    $this->db->from("tbl_users");
    $this->db->where("emp_code", $empcode);
    $this->db->where("isDeleted", 0);
    if ($userId != 0) {
      $this->db->where("userId !=", $userId);
    }
    $query = $this->db->get();

    return $query->result();
  }

  function checkEmployeeUsername($username, $userId = 0) {
    $this->db->select("username");
    $this->db->from("tbl_users");
    $this->db->where("username", $username);
    $this->db->where("isDeleted", 0);
    if ($userId != 0) {
      $this->db->where("userId !=", $userId);
    }
    $query = $this->db->get();

    return $query->result();
  }

  function insertRecord($tbl, $attribute) {
    $this->db->trans_start();
    $this->db->insert($tbl, $attribute);
    $insert_id = $this->db->insert_id();
    $this->db->trans_complete();
    return $insert_id;
  }

  /**
   * This function is used to add new user to system
   * @return number $insert_id : This is last inserted id
   */
  function addNewUser($userInfo) {
    $this->db->trans_start();
    $this->db->insert('tbl_users', $userInfo);

    $insert_id = $this->db->insert_id();

    $this->db->trans_complete();

    return $insert_id;
  }

  /**
   * This function used to get user information by id
   * @param number $userId : This is user id
   * @return array $result : This is user information
   */
  function getUserInfo($userId) {
    $this->db->select('tbl_users.userId,'
        . 'tbl_users.main_department, '
        . 'tbl_users.name, '
        . 'tbl_users.email,'
        . 'tbl_users.username,'
        . 'tbl_users.shift,'
        . 'tbl_users.emp_id, '
        . 'tbl_users.mobile,'
        . 'tbl_users.designation,'
        . 'tbl_users.roleId,'
        . 'tbl_users.avatar,'
        . 'tbl_users.organization_id,'
        . 'tbl_users.client_id,'
        . 'tbl_users.department_id,'
        . 'tbl_departments.dept_name,'
        . 'tbl_organization.org_name,'
        . 'tbl_roles.role,'
        . 'tbl_users.skills,'
        . 'tbl_users.skills,'
        . 'tbl_roles.role,'
        . 'tbl_users.emp_code,'
        . 'tbl_users.doj,'
        . 'tbl_users.reporting_manager,'
        . 'tbl_users.location,'
        . 'tbl_users.sub_department_id');
    $this->db->from('tbl_users');
    $this->db->where('tbl_users.isDeleted', 0);
    $this->db->where('userId', $userId);
    $this->db->join('tbl_organization', 'tbl_organization.id = tbl_users.organization_id', 'LEFT');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id = tbl_users.department_id', 'LEFT');
    $this->db->join('tbl_roles', 'tbl_roles.roleId = tbl_users.roleId');
    $query = $this->db->get();

    return $query->row();
  }

  function getvisitorinfo($visitorId) {

    $this->db->select('tbl_appointment_details.*,tbl_visitor_list.first_name,tbl_visitor_list.last_name,tbl_visitor_list.contact_no,tbl_visitor_list.access_no,tbl_visitor_list.visitor_image,tbl_visitor_list.visitorid_image,tbl_visitor_list.checkin,tbl_visitor_list.checkin_datetime,tbl_visitor_list.checkin_gate,tbl_visitor_list.checkout,tbl_visitor_list.checkout_datetime,tbl_visitor_list.checkout_gate,tbl_visitor_list.item_list,tbl_visitor_list.item_description,tbl_users.name as employeename,tbl_visitor_organization.org_name as visitororganization');
    $this->db->where('tbl_visitor_list.id', $visitorId);
    $this->db->from('tbl_visitor_list');
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->join('tbl_visitor_organization', 'tbl_visitor_organization.id=tbl_appointment_details.visitor_organization');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_appointment_details.user_id');
    return $result = $this->db->get()->row_array();
  }

  /**
   * This function is used to update the user information
   * @param array $userInfo : This is users updated information
   * @param number $userId : This is user id
   */
  function editUser($userInfo, $userId) {
    //echo $userId;
    //die;
    $this->db->where('userId', $userId);
    $this->db->update('tbl_users', $userInfo);

    return TRUE;
  }

 function employeeRemoveFromTeam($userId) {
    $userInfo['client_id'] = null;
    $userInfo['department_id'] = null;
    $userInfo['sub_department_id'] = null;
    $userInfo['current_status'] = '0';
    $userInfo['reporting_manager'] = null;
    $this->db->where('reporting_manager', $userId);
    $this->db->update('tbl_users', $userInfo);
//    last_query();

    return TRUE;
  }

  /**
   * This function is used to delete the user information
   * @param number $userId : This is user id
   * @return boolean $result : TRUE / FALSE
   */
  function deleteUser($userId, $userInfo) {
    $this->db->where('userId', $userId);
    //$this->db->update('tbl_users', $userInfo);
    $this->db->delete('tbl_users');

    return $this->db->affected_rows();
  }

  function deleteAllUser($userRowId, $userInfo) {
    $this->db->where('excel_id', $userRowId);
    $this->db->delete('tbl_users');
    return $this->db->affected_rows();
  }

  function deleteAllPro($userRowId, $userInfo) {
    $this->db->where('excel_id', $userRowId);
    $this->db->delete('tbl_manpower_team_performance');
    return $this->db->affected_rows();
  }

  /**
   * This function is used to match users password for change password
   * @param number $userId : This is user id
   */
  function matchOldPassword($userId, $oldPassword) {
    $this->db->select('userId, password');
    $this->db->where('userId', $userId);
    $this->db->where('isDeleted', 0);
    $query = $this->db->get('tbl_users');

    $user = $query->result();

    if (!empty($user)) {
      if (verifyHashedPassword($oldPassword, $user[0]->password)) {
        return $user;
      } else {
        return array();
      }
    } else {
      return array();
    }
  }

  /**
   * This function is used to change users password
   * @param number $userId : This is user id
   * @param array $userInfo : This is user updation info
   */
  function changePassword($userId, $userInfo) {
    $this->db->where('userId', $userId);
    $this->db->where('isDeleted', 0);
    $this->db->update('tbl_users', $userInfo);

    return $this->db->affected_rows();
  }

  /**
   * This function is used to get user login history
   * @param number $userId : This is user id
   */
  function loginHistoryCount($userId, $searchText, $fromDate, $toDate) {
    $this->db->select('BaseTbl.userId, BaseTbl.sessionData, BaseTbl.machineIp, BaseTbl.userAgent, BaseTbl.agentString, BaseTbl.platform, BaseTbl.createdDtm');
    if (!empty($searchText)) {
      $likeCriteria = "(BaseTbl.sessionData LIKE '%" . $searchText . "%')";
      $this->db->where($likeCriteria);
    }
    if (!empty($fromDate)) {
      $likeCriteria = "DATE_FORMAT(BaseTbl.createdDtm, '%Y-%m-%d' ) >= '" . date('Y-m-d', strtotime($fromDate)) . "'";
      $this->db->where($likeCriteria);
    }
    if (!empty($toDate)) {
      $likeCriteria = "DATE_FORMAT(BaseTbl.createdDtm, '%Y-%m-%d' ) <= '" . date('Y-m-d', strtotime($toDate)) . "'";
      $this->db->where($likeCriteria);
    }
    if ($userId >= 1) {
      $this->db->where('BaseTbl.userId', $userId);
    }
    $this->db->from('tbl_last_login as BaseTbl');
    $query = $this->db->get();

    return $query->num_rows();
  }

  /**
   * This function is used to get user login history
   * @param number $userId : This is user id
   * @param number $page : This is pagination offset
   * @param number $segment : This is pagination limit
   * @return array $result : This is result
   */
  function loginHistory($userId, $searchText, $fromDate, $toDate, $page, $segment) {
    $this->db->select('BaseTbl.userId, BaseTbl.sessionData, BaseTbl.machineIp, BaseTbl.userAgent, BaseTbl.agentString, BaseTbl.platform, BaseTbl.createdDtm,BaseTbl.skills');
    $this->db->from('tbl_last_login as BaseTbl');
    if (!empty($searchText)) {
      $likeCriteria = "(BaseTbl.sessionData  LIKE '%" . $searchText . "%')";
      $this->db->where($likeCriteria);
    }
    if (!empty($fromDate)) {
      $likeCriteria = "DATE_FORMAT(BaseTbl.createdDtm, '%Y-%m-%d' ) >= '" . date('Y-m-d', strtotime($fromDate)) . "'";
      $this->db->where($likeCriteria);
    }
    if (!empty($toDate)) {
      $likeCriteria = "DATE_FORMAT(BaseTbl.createdDtm, '%Y-%m-%d' ) <= '" . date('Y-m-d', strtotime($toDate)) . "'";
      $this->db->where($likeCriteria);
    }
    if ($userId >= 1) {
      $this->db->where('BaseTbl.userId', $userId);
    }
    $this->db->order_by('BaseTbl.id', 'DESC');
    $this->db->limit($page, $segment);
    $query = $this->db->get();

    $result = $query->result();
    return $result;
  }

  /**
   * This function used to get user information by id
   * @param number $userId : This is user id
   * @return array $result : This is user information
   */
  function getUserInfoById($userId) {
    $this->db->select('tbl_users.userId, tbl_users.name, tbl_users.email, tbl_users.mobile, tbl_users.roleId,tbl_organization.org_name,tbl_users.emp_code,tbl_users.emp_id,tbl_users.designation,tbl_users.avatar,tbl_users.shift,tbl_users.skills,tbl_users.doj,tbl_departments.dept_name');
    $this->db->from('tbl_users');
    $this->db->join('tbl_organization', 'tbl_organization.id=organization_id');
    $this->db->join('tbl_departments', 'tbl_departments.dept_id=department_id');
    $this->db->where('tbl_users.isDeleted', 0);
    //$this->db->where('tbl_organization.isDeleted', 0);
    $this->db->where('userId', $userId);
    $query = $this->db->get();

    return $query->row();
  }

  /**
   * This function used to get user information by id with role
   * @param number $userId : This is user id
   * @return array $result : This is user information
   */
  function getUserInfoWithRole($userId) {
    $this->db->select('BaseTbl.userId, BaseTbl.email, BaseTbl.name, BaseTbl.mobile, BaseTbl.roleId, Roles.role,BaseTbl.avatar,BaseTbl.skills,BaseTbl.doj,BaseTbl.reporting_manager');
    $this->db->from('tbl_users as BaseTbl');
    $this->db->join('tbl_roles as Roles', 'Roles.roleId = BaseTbl.roleId');
    $this->db->where('BaseTbl.userId', $userId);
    $this->db->where('BaseTbl.isDeleted', 0);
    $query = $this->db->get();

    return $query->row();
  }

  function getTodayLoginDetail($userId) {
    $this->db->like('created_at', date('Y-m-d'));
    $this->db->where('user_id', $userId);
    $this->db->where('type', 'in');
    $signIn = $this->db->get('tbl_attendances')->row_array();

    if (isset($signIn['created_at'])) {
      $signOut = $this->getsignoutdatetime($userId, 'out', $signIn['created_at']);
    } else {
      $signOut = '';
    }

    //$this->db->like('created_at', date('Y-m-d'));
    //$this->db->where('user_id',$userId);
    //$this->db->where('type','out');
    //$signOut = $this->db->get('tbl_attendances')->row_array();
    return ['signInTime' => isset($signIn['created_at']) ? $signIn['created_at'] : '', 'signOutTime' => $signOut];
  }

  function checktodayattendance($userId, $status) {
    if ($status == 'out') {
      $this->db->like('created_at', date('Y-m-d'));
      $this->db->where('user_id', $userId);
      //$this->db->where('type',$status);
      $this->db->limit(1);
      $this->db->order_by('created_at', 'DESC');
      $result = $this->db->get('tbl_attendances')->row_array();
      if (isset($result) && $result['type'] == 'in') {
        return false;
      } else {
        return true;
      }
    } else {
      $this->db->like('created_at', date('Y-m-d'));
      $this->db->where('user_id', $userId);
      $this->db->where('type', $status);
      return $this->db->get('tbl_attendances')->num_rows();
    }
  }

  function getsignoutdatetime($userId, $status, $signIndate) {
    $this->db->select('created_at');
    $this->db->where('user_id', $userId);
    $this->db->where('type', $status);
    $this->db->where('created_at >', $signIndate);
    $this->db->order_by('created_at', 'ASC');
    $this->db->limit(1);
    $signoutDate = $this->db->get('tbl_attendances')->row_array();
    if (isset($signoutDate['created_at'])) {
      return $signoutDate['created_at'];
    } else {
      return '';
    }
  }

  function getsigninattendenceTime($userId, $status, $date) {
    $this->db->select('created_at');
    $this->db->where('user_id', $userId);
    $this->db->where('type', $status);
    $this->db->like('created_at', $date);
    $result = $this->db->get('tbl_attendances')->row_array();
    if (isset($result['created_at'])) {
      return $result['created_at'];
    } else {
      return '';
    }
  }

  function getTotalworkinghours($signIn, $signOut) {

    if ($signOut == '') {
      $signOut = date('Y-m-d H:i:s');
    }

    $starttimestamp = new DateTime($signIn);
    $endtimestamp = new DateTime($signOut);
    $interval = $starttimestamp->diff($endtimestamp);
    $result = $interval->format('%H') . ":" . $interval->format('%I') . ":" . $interval->format('%S');
    return $result;
  }

  function getDepartmentList($organizationId = '', $departmentId = '', $withManPowerCount = '0', $isSubDepartmentAvailable = '0') {
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->not_like('tbl_departments.dept_name', 'FTU');
    if ($organizationId) {
      $this->db->where('tbl_departments.org_id', $organizationId);
    }
    if ($isSubDepartmentAvailable) {
      $this->db->join('tbl_sub_departments', 'tbl_sub_departments.dept_id=tbl_departments.dept_id');
      $this->db->where('tbl_sub_departments.isDeleted', '0');
      $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    }
    if ($departmentId) {
      $this->db->where('dept_id', $departmentId);
      return $this->db->get('tbl_departments')->row_array();
    } elseif ($withManPowerCount) {
      $this->db->select('tbl_departments.*,count(tbl_users.userId) as manpower');
      $this->db->join('tbl_users', 'tbl_users.department_id=tbl_departments.dept_id', 'left');
      $this->db->where('tbl_users.organization_id', $organizationId);
      $this->db->where('tbl_users.isDeleted', '0')->group_by('tbl_departments.dept_id');
      $data = $this->db->get('tbl_departments')->result_array();
      return $data;
    } else {
      $data = $this->db->group_by('tbl_departments.dept_id')->where('tbl_departments.org_id', $organizationId)->get('tbl_departments')->result_array();
      return $data;
    }
  }

  function getMainDepartmentList($organizationId = '', $departmentId = '', $withManPowerCount = '0', $isSubDepartmentAvailable = '0') {
    $this->db->where('tbl_departments.isDeleted', '0');
    if ($organizationId) {
      $this->db->where('tbl_departments.org_id', $organizationId);
    }
    if ($isSubDepartmentAvailable) {
      $this->db->join('tbl_sub_departments', 'tbl_sub_departments.dept_id=tbl_departments.dept_id');
      $this->db->where('tbl_sub_departments.isDeleted', '0');
    }
    if ($departmentId) {
      $this->db->where('dept_id', $departmentId);
      return $this->db->get('tbl_departments')->row_array();
    } elseif ($withManPowerCount) {
      $this->db->select('tbl_departments.*,count(tbl_users.userId) as manpower');
      $this->db->join('tbl_users', 'tbl_users.department_id  = tbl_departments.dept_id', 'left');
      $this->db->where('tbl_users.organization_id', $organizationId);
      $this->db->where('tbl_users.isDeleted', '0')->group_by('tbl_departments.dept_id');
      $data = $this->db->get('tbl_departments')->result_array();
      return $data;
    } else {
      $data = $this->db->group_by('tbl_departments.dept_id')->get('tbl_departments')->result_array();
      //echo $this->db->last_query();
      //pre($data);
      return $data;
    }
  }

  function getDepartmentListAll($organizationId = '', $departmentId = '', $withManPowerCount = '0', $isSubDepartmentAvailable = '0') {
    $this->db->where('tbl_departments.isDeleted', '0');
    $this->db->not_like('tbl_departments.dept_name', 'FTU');
    if ($organizationId) {
      $this->db->where('tbl_departments.org_id', $organizationId);
    }
    if ($isSubDepartmentAvailable) {
      $this->db->join('tbl_sub_departments', 'tbl_sub_departments.dept_id=tbl_departments.dept_id');
      $this->db->where('tbl_sub_departments.isDeleted', '0');
      $this->db->not_like('tbl_sub_departments.sub_dept_name', 'FTU');
    }
    if ($departmentId) {
      $this->db->where('dept_id', $departmentId);
      return $this->db->get('tbl_departments')->row_array();
    } elseif ($withManPowerCount) {
      $this->db->select('tbl_departments.*,count(tbl_users.userId) as manpower');
      $this->db->join('tbl_users', 'tbl_users.department_id = tbl_departments.dept_id', 'left');
      $this->db->where('tbl_users.organization_id', $organizationId);
      $this->db->not_like('tbl_departments.dept_name', 'FTU');
      $this->db->where('tbl_users.isDeleted', '0')->group_by('tbl_departments.dept_id');
      $data = $this->db->get('tbl_departments')->result_array();
      return $data;
    } else {
      $data = $this->db->group_by('tbl_departments.dept_id')->get('tbl_departments')->result_array();
      //echo $this->db->last_query();
      //pre($data);
      return $data;
    }
  }

//  function getSubDepartmentList($organizationId = '', $departmentId = '', $withManPowerCount = '0') {
//    $this->db->where('tbl_departments.isDeleted', '0');
//
//    if ($departmentId) {
//      $this->db->where('dept_id', $departmentId);
//      return $this->db->get('tbl_sub_departments')->row_array();
//    } elseif ($withManPowerCount) {
//      $this->db->select('tbl_departments.*,count(tbl_users.userId) as manpower');
//      $this->db->join('tbl_users', 'tbl_users.department_id=tbl_departments.dept_id', 'left');
//      $this->db->where('tbl_users.organization_id', $organizationId);
//      $this->db->where('tbl_users.isDeleted', '0')->group_by('tbl_departments.dept_id');
//      $data = $this->db->get('tbl_departments')->result_array();
//      return $data;
//    } else {
//      return $this->db->get('tbl_departments')->result_array();
//    }
//  }


  function getPerformaceEmployeeBySubDepartment($subDeptId) {
    //$empIds = [];
    $performenceArray = $this->db->query('SELECT tbl_manpower_team_performance.employee_id FROM tbl_manpower_team_performance WHERE sub_dept_id = ' . $subDeptId . ' group by tbl_manpower_team_performance.employee_id')->result_array();
    //echo $this->db->last_query();
    //pre($performenceArray);
    $empIds = array_column($performenceArray, 'employee_id');
    if (isset($performenceArray) && is_array($performenceArray) && !empty($performenceArray)) {
      $this->db->select('tbl_users.name,tbl_users.userId');
      $this->db->join('tbl_manpower_team_performance', 'tbl_manpower_team_performance.sub_dept_id = tbl_users.sub_department_id ', 'left');
//      $this->db->where('tbl_users.sub_department_id', $subDeptId)->where_in('tbl_users.userId', $empIds)->group_by('tbl_users.userId');
      $this->db->where_in('tbl_users.userId', $empIds)->group_by('tbl_users.userId');
      $data = $this->db->get('tbl_users')->result_array();
      return $data;
    } else {
      return [];
    }
  }

  function getSubDepartmentList($departmentId = '', $subDepartmentId = '', $withManPowerCount = '0', $type = '') {
    $this->db->where('tbl_sub_departments.isDeleted', '0');
    if ($subDepartmentId) {
      $this->db->where('tbl_sub_departments.id', $subDepartmentId);
      $this->db->select('tbl_sub_departments.*');
      $this->db->join('tbl_organization', 'tbl_organization.id=tbl_sub_departments.org_id', 'left');
      $this->db->join('tbl_departments', 'tbl_departments.dept_id=tbl_sub_departments.dept_id', 'left');
      return $this->db->get('tbl_sub_departments')->row_array();
    }
    if ($type != 'all') {
      $this->db->where('tbl_sub_departments.dept_id', $departmentId);
    }
    $this->db->where('tbl_sub_departments.dept_id', $departmentId);
    $result = $this->db->get('tbl_sub_departments')->result_array();
    return $result;
  }

  function getShiftList($subDepartmentId) {
    //pre($subDepartmentId);
    $this->db->where('shift_mgmt.superviser_id', $this->session->userdata('userId'));
    $this->db->where('shift_mgmt.sub_dept_id', $subDepartmentId);
    $this->db->select('shift_mgmt.shift');
    $data = $this->db->get('shift_mgmt')->row_array();
    //last_query();
    return $data;
  }

  function getshiftlistreportajax($orgId, $clientId, $departmentId, $subDepartmentId) {
    //pre($subDepartmentId);
    //$this->db->where('shift_mgmt.superviser_id', $this->session->userdata('userId'));
    $this->db->where('shift_mgmt.org_id', $orgId);
    //$this->db->where('shift_mgmt.sub_dept_id', $clientId);
    $this->db->where('shift_mgmt.dept_id', $departmentId);
    $this->db->where('shift_mgmt.sub_dept_id', $subDepartmentId);
    $this->db->select('shift_mgmt.shift');
    $data = $this->db->get('shift_mgmt')->result_array();
    //last_query();
    return $data;
  }

  function getLocationList($organizationId = '', $locationId = '') {
    //$this->db->where('isDeleted','0');
    if ($organizationId) {
      $this->db->where('org_id', $organizationId);
    }

    if ($locationId) {
      $this->db->where('id', $locationId);
      return $this->db->get('tbl_warehouse_location')->row_array();
    } else {
      return $this->db->get('tbl_warehouse_location')->result_array();
    }
  }

  function getOrganizationList($orgID = '', $withManPowerCount = '0') {
    $this->db->where('tbl_organization.isDeleted', '0');
    if ($orgID) {
      $this->db->where('id', $orgID);
      return $this->db->get('tbl_organization')->result_array();
    } elseif ($withManPowerCount) {
      $this->db->select('tbl_organization.*,count(tbl_users.userId) as manpower');
      $this->db->join('tbl_users', 'tbl_users.organization_id=tbl_organization.id', 'left');
      $this->db->where('tbl_users.isDeleted', '0')->where('tbl_users.roleId', '3')->group_by('tbl_organization.id');
      $data = $this->db->get('tbl_organization')->result_array();
      return $data;
    } else {
      return $this->db->get('tbl_organization')->result_array();
    }
  }

  function getLocationByClient($clientId = '') {
    $this->db->where('tbl_location.isDeleted', '0');
    $this->db->where('client_id', $clientId);
    return $this->db->get('tbl_location')->result_array();
  }

  function getClients() {
    return $this->db->get('tbl_clients')->result_array();
  }

  function getWarehouseByLocation($locId = '') {
    $this->db->where('tbl_organization.isDeleted', '0');
    $this->db->where('loc_id', $locId);

    return $this->db->get('tbl_organization')->result_array();
    // echo $this->db->last_query();die;
  }

  function getWarehouseByClient($clientId = '') {
    $this->db->where('tbl_organization.isDeleted', '0');
    $this->db->where('client_id', $clientId);
    return $this->db->get('tbl_organization')->result_array();
  }

  function getClientByWarehouse($orgId = '', $locId = '', $type = '') {
    $clientArray = [];
    $this->db->where('tbl_organization.isDeleted', '0');
    if ($type != 'all') {
      $this->db->where('id', $orgId);
    }

    $clientString = $this->db->get('tbl_organization')->row()->client_id;
//    last_query();
//    pre($clientString);
    $clientIdArray = explode($delimiter = ',', $clientString);
//    pre($clientIdArray);
    foreach ($clientIdArray as $key => $value) {
      $clientArray[$key]['id'] = $value;
      $clientArray[$key]['name'] = clientName($value);
    }
//    pre($clientArray);
    return $clientArray;
  }

  function getClientByClientId($clientId = '') {
    $this->db->select('tbl_clients.*');
    $this->db->where_in('tbl_clients.id', explode(',', $clientId));
    $data = $this->db->get('tbl_clients')->result_array();
//    last_query();
    return $data;
  }

  function getvisitortypelist() {
    $this->db->select('visitor_type');
    $this->db->order_by('visitor_type', 'ASC');
    return $this->db->get('tbl_visitor_category')->result_array();
  }

  function getDepartmentCountInSubDepartment($deptId) {
    $this->db->select('*');
    $this->db->where('dept_id', $deptId);
    return $this->db->get('tbl_sub_departments')->row_array();
  }

  function getvisitorpurpose() {
    $this->db->select('purpose');
    $this->db->order_by('purpose', 'ASC');
    return $this->db->get('tbl_visitor_purpose')->result_array();
  }

  function checklastsignout($userId) {
    $this->db->select('DATE(created_at) as date');
    $this->db->where('type', 'in');
    $this->db->where('user_id', $userId);
    $this->db->order_by('created_at', 'DESC');
    $signInInfo = $this->db->get('tbl_attendances')->row_array();
    $lastsignInDate = isset($signInInfo['date']) ? $signInInfo['date'] : '1990-01-01';

    $this->db->select('DATE(created_at)');
    $this->db->where('type', 'out');
    $this->db->where('user_id', $userId);
    $this->db->order_by('created_at', 'DESC');
    $signOutInfo = $this->db->get('tbl_attendances')->row_array();
    $lastsignOutDate = isset($signOutInfo['date']) ? $signOutInfo['date'] : '1990-01-01';

    if ($lastsignInDate > $lastsignOutDate) {

      return true;
    } else {

      return false;
    }
  }

  function getskillslist() {
    $result = array();
    $this->db->select('skill');
    $this->db->where('isDeleted', '0');
    $skilllist = $this->db->get('tbl_skills')->result_array();

    if (!empty($skilllist)) {
      foreach ($skilllist as $skill) {
        $result[] = $skill['skill'];
      }
    }

    return $result;
  }

  function getTicketDetail($ticketId) {
    $this->db->where('id', $ticketId);
    $result = $this->db->get('tbl_tickets')->row_array();
    return $result;
    /* echo '<pre>';
      print_r($result);
      die; */
  }

  function getTotalTicketCount($type, $role) {
    $userId = $this->session->userdata('userId');
    if ($role != '1') {
      /* $this->db->where('tbl_ticket_assign_user.assign_user',$userId);
        $this->db->or_where('tbl_tickets.user_id',$userId); */
      $this->db->where("(tbl_ticket_assign_user.assign_user = '" . $userId . "' OR tbl_tickets.user_id = '" . $userId . "')");
    }
    if ($type == '0') {
      //$this->db->where('tbl_tickets.status','0');
      $this->db->where("(tbl_tickets.status = '0' OR tbl_tickets.status = '2')");
    } elseif ($type == '1') {
      $this->db->where('tbl_tickets.status', '1');
    }
    $this->db->from('tbl_ticket_assign_user');
    $this->db->join('tbl_tickets', 'tbl_tickets.id=tbl_ticket_assign_user.ticket_no');
    $this->db->group_by('tbl_ticket_assign_user.ticket_no');
    return $totalrows = $this->db->get()->num_rows();
  }

  function getTicketCommentList($ticketId) {
    $this->db->select('tbl_ticket_comments.*,tbl_users.name');
    $this->db->where('tbl_ticket_comments.ticket_id', $ticketId);
    $this->db->from('tbl_ticket_comments');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_ticket_comments.user_id');
    $this->db->order_by('tbl_ticket_comments.created_at', 'DESC');
    return $result = $this->db->get()->result_array();
  }

  function getTicketAssignUserList($ticketId) {
    $this->db->select('assign_user as userid,tbl_users.name');
    $this->db->from('tbl_ticket_assign_user');
    $this->db->where('tbl_ticket_assign_user.ticket_no', $ticketId);
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_ticket_assign_user.assign_user');
    $result = $this->db->get()->result_array();
    return $result;
  }

  function gettotalvisitor() {
    $this->db->from('tbl_visitor_list');
    $this->db->join('tbl_appointment_details', 'tbl_appointment_details.id=tbl_visitor_list.appointment_id');
    $this->db->where('tbl_visitor_list.checkin', '1');
    return $this->db->get()->num_rows();
    //return 0;
  }

  function getsupporticket() {
    $this->db->from('tbl_tickets');
    $this->db->join('tbl_users', 'tbl_users.userId=tbl_tickets.user_id');
    return $this->db->get()->num_rows();
  }

}
