<?php

if (!defined('BASEPATH'))
  exit('No direct script access allowed');

/**
 * Class : User_model (User Model)
 * User model class to get to handle user related data
 * @author : Vijayraj Chaudhary
 * @version : 2.1
 * @since : 15 November 2019
 */
class Shift_model extends CI_Model {

  function getShiftInfo($shiftId = '') {
    $this->db->where('shift_mgmt.isDeleted', '0');
    if ($shiftId) {
      $this->db->where('shift_mgmt.id', $shiftId);
      $this->db->select('shift_mgmt.*,tbl_shift.shift_name');
      $this->db->join('tbl_shift', 'tbl_shift.id=shift_mgmt.shift', 'left');
      return $this->db->get('shift_mgmt')->row_array();
    }
    $result = $this->db->get('shift_mgmt')->result_array();
    return $result;
  }

  function getShiftListBySubDeptId($subDeptId = '') {
    $this->db->where('shift_mgmt.isDeleted', '0');
    $this->db->where('shift_mgmt.sub_dept_id', $subDeptId);
    $this->db->select('shift_mgmt.*,tbl_shift.shift_name');
    $this->db->join('tbl_shift', 'tbl_shift.id = shift_mgmt.shift', 'left');
    return $this->db->get('shift_mgmt')->result_array();
  }

}
