<?php
require_once '../init.php';
header('Content-Type: application/json');

// Turn off unnecessary error output for performance
error_reporting(0);
ini_set('display_errors', 0);

$response = ['success' => false, 'message' => '', 'data' => []];

// Read warehouse_id (supports both JSON and POST)
$data = json_decode(file_get_contents('php://input'), true);
$warehouse_id = isset($data['warehouse_id']) ? trim($data['warehouse_id']) : (isset($_POST['warehouse_id']) ? trim($_POST['warehouse_id']) : '');

// if ($warehouse_id === '') {
//     $response['message'] = 'Warehouse ID is required';
//     echo json_encode($response);
//     exit;
// }

$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);

// ✅ Use index-friendly query with WHERE filter
// Add LIMIT for performance and ORDER for consistency
$sql = "SELECT vehicle_number, gate_entry_no, transporter_name, gate_pass_number FROM security_check_details WHERE is_loading_unloading = 0 ORDER BY id DESC";

$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $vehicles = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $vehicles[] = [
            'vehicle_number'    => $row['vehicle_number'],
            'gate_entry_no'     => $row['gate_entry_no'],
            'transporter_name'  => $row['transporter_name'],
            'gate_pass_number'  => $row['gate_pass_number']
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Vehicle details fetched successfully';
    $response['data'] = $vehicles;
} else {
    $response['message'] = 'No vehicle details found';
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>
