<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$warehouse_id = '';

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

if ($warehouse_id === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Warehouse ID is required',
        'data' => []
    ]);
    exit;
}

$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);

// -------------------------------
// Fetch PO details where total PO qty > total received qty
// -------------------------------
$sql = "SELECT pd.po_no, pd.sender_name, COALESCE(SUM(pm.qty), 0) AS total_po_qty, COALESCE(SUM(ue.grn_rev_qty + ue.issue), 0) AS total_received_qty FROM po_details pd LEFT JOIN po_material pm ON pm.po_id = pd.id LEFT JOIN upload_excel ue ON ue.lrno = pd.po_no GROUP BY pd.po_no, pd.sender_name HAVING total_po_qty > total_received_qty ORDER BY pd.po_no DESC";

$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $po_list = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $po_list[] = [
            'PO Number'        => $row['po_no'],
            'Supplier Name'    => $row['sender_name'],
            'Total PO Qty'     => (float)$row['total_po_qty'],
            'Received Qty'     => (float)$row['total_received_qty'],
            'Pending Qty'      => (float)$row['total_po_qty'] - (float)$row['total_received_qty']
        ];
    }

    echo json_encode([
        'success' => true,
        'message' => 'PO details fetched successfully',
        'data' => $po_list
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'No pending PO found for this warehouse',
        'data' => []
    ]);
}
?>
