<?php
require_once '../init.php';
header('Content-Type: application/json');

// Decode JSON or form-data
$data = json_decode(file_get_contents('php://input'), true);
$picking_id = '';

if (isset($data['picklist_id'])) {
    $picking_id = trim($data['picklist_id']);
} elseif (isset($_POST['picklist_id'])) {
    $picking_id = trim($_POST['picklist_id']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

// Validation
if ($picking_id === '') {
    $response['message'] = 'Picklist ID is required';
    echo json_encode($response, JSON_PRETTY_PRINT);
    exit;
}

$picking_id = mysqli_real_escape_string($mycon, $picking_id);

// Get order details based on picking_id
$sql = "SELECT om.order_id,om.ref_number, om.invoice_number, om.s_location, om.s_area, om.warehouse_id, pg.picking_id FROM picklist_generation pg LEFT JOIN order_management om  ON pg.order_id = om.order_id WHERE pg.picking_id = '$picking_id' LIMIT 1";

$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);

    $response['success'] = true;
    $response['message'] = 'Order fetched successfully';
    $response['data'] = [
        'PickingId'       => $row['picking_id'],
        'OrderId'         => $row['order_id'],
        'SalesDeliveryNo' => $row['ref_number'],
        'ChallanNo'       => $row['invoice_number'],
        'Location'        => $row['s_location'],
        'KitchenArea'     => $row['s_area'],
        'WarehouseId'     => $row['warehouse_id']
    ];
} else {
    $response['message'] = 'No order found for this Picking ID';
}

echo json_encode($response, JSON_PRETTY_PRINT);
?>
