<?php
require_once '../init.php';

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$order_id = '';
if (isset($data['order_id'])) {
    $order_id = trim($data['order_id']);
} elseif (isset($_POST['order_id'])) {
    $order_id = trim($_POST['order_id']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

if ($order_id === '') {
    $response['message'] = 'Order ID is required';
    echo json_encode($response);
    exit;
}

$order_id = mysqli_real_escape_string($mycon, $order_id);

// Fetch order materials
$sql = "SELECT order_id, product_code, product_desc FROM order_material WHERE order_id = '$order_id' ORDER BY id ASC";

$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $materials = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $product_code = mysqli_real_escape_string($mycon, $row['product_code']);

        $batch_sql = "SELECT batch FROM picklist_generation WHERE order_id = '$order_id' AND pro_code = '$product_code' ORDER BY id ASC LIMIT 1";

        $batch_result = mysqli_query($mycon, $batch_sql);
        $batch_code = '';
        if ($batch_result && mysqli_num_rows($batch_result) > 0) {
            $batch_row = mysqli_fetch_assoc($batch_result);
            $batch_code = $batch_row['batch'];
        }

        $materials[] = [
            'OrderId'     => $row['order_id'],
            'ProductCode' => $row['product_code'],
            'ProductDesc' => $row['product_desc'],
            'BatchCode'   => $batch_code
        ];
    }

    $response['success'] = true;
    $response['message'] = 'Order Materials Fetched Successfully';
    $response['data'] = $materials;
} else {
    $response['message'] = 'No materials found';
}

echo json_encode($response);
