<?php
require_once '../init.php';
header('Content-Type: application/json');

// Read input (JSON or POST)
$data = json_decode(file_get_contents('php://input'), true);

$crate_id = '';
if (isset($data['crate_id'])) {
    $crate_id = trim($data['crate_id']);
} elseif (isset($_POST['crate_id'])) {
    $crate_id = trim($_POST['crate_id']);
}

$response = ['success' => false, 'message' => '', 'data' => []];

if ($crate_id === '') {
    $response['message'] = 'Crate ID is required';
    echo json_encode($response);
    exit;
}

$crate_id = mysqli_real_escape_string($mycon, $crate_id);

// Check if crate exists
$sql_check = "SELECT * FROM crate_registation_tbl WHERE crate_id = '$crate_id'";
$result = mysqli_query($mycon, $sql_check);

if ($result && mysqli_num_rows($result) > 0) {
    $crate = mysqli_fetch_assoc($result); // optional, you can return crate info
    $response['success'] = true;
    $response['message'] = 'Crate Found';
    $response['data'] = [
        'crate_id' => $crate['crate_id']
    ];
} else {
    $response['message'] = 'Invalid Crate ID';
}

echo json_encode($response);
