<?php
require_once '../init.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

$warehouse_id = '';

if (isset($data['warehouse_id'])) {
    $warehouse_id = trim($data['warehouse_id']);
} elseif (isset($_POST['warehouse_id'])) {
    $warehouse_id = trim($_POST['warehouse_id']);
}

if ($warehouse_id === '') {
    echo json_encode([
        'success' => false,
        'message' => 'Warehouse ID is required',
        'data' => []
    ]);
    exit;
}

$warehouse_id = mysqli_real_escape_string($mycon, $warehouse_id);

// -------------------------------
// Fetch challan details along with vendor name
// -------------------------------
$sql = "SELECT vc.challan_no, vc.vendor_code, vm.sender_name AS vendor_name, vc.po_no, SUM(vc.qty) AS qty, vc.po_qty FROM vendor_challan_tbl vc LEFT JOIN unloading_sender_details vm ON vc.vendor_code COLLATE utf8mb4_unicode_ci = vm.sender_code GROUP BY vc.challan_no";

$result = mysqli_query($mycon, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    $vehicles = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $vehicles[] = [
            'Challan No'     => $row['challan_no'],
            'Supplier Code'  => $row['vendor_code'],
            'Supplier Name'  => $row['vendor_name'], // Added vendor name
            'PO Number'      => $row['po_no'],
            'Total Challan Qty' => $row['qty'],
            'Total PO Qty'   => $row['po_qty'],
        ];
    }
    echo json_encode([
        'success' => true,
        'message' => 'Challan details Fetched Successfully',
        'data' => $vehicles
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'No challan details found for this warehouse',
        'data' => []
    ]);
}
?>
