<?php
require_once '../init.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
}

?>
<!DOCTYPE html>
<html lang="en">
<!--<![endif]-->
<!-- BEGIN HEAD -->

<head>
    <meta charset="utf-8" />
    <title><?php echo $header_project_name; ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="<?php echo $wmsData['about_wh']; ?>" name="description" />
    <meta content="Vikas Singh" name="author" />
    <?php include 'shared/header.php'; ?>
    <style type="text/css">
        table {
            font-family: arial, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        th {
            background-color: #1fac8b;
        }

        td,
        th {
            border: 1px solid #dddddd;
            text-align: left;
            padding-top: 10px;
            padding-bottom: 10px;
            padding-left: 10px;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 21px !important;
            width: 12px !important;
            left: 3px !important;
            bottom: 3px !important;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked+.slider {
            background-color: #1fac8b;
        }

        input:focus+.slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked+.slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 15px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>

    <script>
        function disabledval(id, buttonvalue) {
            //alert('disabled'+id);
            var checkvalue = 0;
            var type = 4;
            var status = confirm("You want to disable it. After Confirmation it will be disabled");
            if (status) {
                if (id != '') {
                    urll = "process_and_department_setting.php?checkvalue=" + checkvalue + "&id=" + id + "&type=" + type;
                    //prompt("Copy to clipboard: Ctrl+C, Enter", urll);
                    var xhttp = new XMLHttpRequest();
                    xhttp.onreadystatechange = function() {
                        if (this.readyState == 4 && this.status == 200) {
                            window.location = "wms_plan.php";
                        }
                    };
                    xhttp.open("GET", urll, true);
                    xhttp.send();

                } else {
                    alert('Kindly click action button');
                }
            } else {
                window.location = "wms_plan.php";
            }
        }

        function enabledval(id, buttonvalue) {
            //alert('enabled'+id);
            var checkvalue = 1;
            var type = 4;
            var status = confirm("You want to enable it. After Confirmation it will be enabled");
            if (status) {
                if (id != '') {
                    urll = "process_and_department_setting.php?checkvalue=" + checkvalue + "&id=" + id + "&type=" + type;
                    //prompt("Copy to clipboard: Ctrl+C, Enter", urll);
                    var xhttp = new XMLHttpRequest();
                    xhttp.onreadystatechange = function() {
                        if (this.readyState == 4 && this.status == 200) {
                            window.location = "wms_plan.php";
                        }
                    };
                    xhttp.open("GET", urll, true);
                    xhttp.send();

                } else {
                    alert('Kindly click action button');
                }
            } else {
                window.location = "wms_plan.php";
            }
        }
    </script>

</head>


<body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white page-sidebar-closed page-md">

    <div class="page-wrapper">
        <?php include 'top_menu.php'; ?>
        <!-- BEGIN HEADER & CONTENT DIVIDER -->
        <div class="clearfix"> </div>
        <!-- END HEADER & CONTENT DIVIDER -->
        <!-- BEGIN CONTAINER -->
        <div class="page-container">
            <?php include 'sidebar.php'; ?>

            <!-- BEGIN CONTENT -->
            <div class="page-content-wrapper">
                <!-- BEGIN CONTENT BODY -->
                <div class="page-content">

                    <div class="row">
                        <div class="col-md-12">
                            <!-- Begin: life time stats -->
                            <div class="portlet light portlet-fit portlet-datatable bordered">
                                <div class="portlet-title">
                                    <!-- <div class="col-md-12" >
                                          <div class="col-md-8" >
                                               <div class="tabbable-line">
                                                   <ul class="nav nav-tabs nav-tabs-lg">
                                                       <li><a href="department_process_management.php"> Menu Setting  </a></li>
                                                       <li><a href="department_process_management.php"> Submenu Setting </a></li>
                                                       <li class="active"><a href="process_transaction_management.php">Process Transaction Management</a></li>
                                                   </ul>
                                               </div>
                                           </div>
                                        </div> -->
                                    <div class="col-md-12">
                                        <h3 style="text-align: center; color: #1fac8b; font-weight: bold;">WMS Plan</h3>

                                    </div>

                                    <div class="actions">

                                        <div class="btn-group" style="display: none;">
                                            <a class="btn red btn-outline btn-circle" href="javascript:;" data-toggle="dropdown">
                                                <i class="fa fa-share"></i>
                                                <span class="hidden-xs"> Tools </span>
                                                <i class="fa fa-angle-down"></i>
                                            </a>
                                            <ul class="dropdown-menu pull-right" id="sample_3_tools">
                                                <li>
                                                    <a href="javascript:;" data-action="0" class="tool-action">
                                                        <i class="icon-printer"></i> Print</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:;" data-action="1" class="tool-action">
                                                        <i class="icon-check"></i> Copy</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:;" data-action="2" class="tool-action">
                                                        <i class="icon-doc"></i> PDF</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:;" data-action="3" class="tool-action">
                                                        <i class="icon-paper-clip"></i> Excel</a>
                                                </li>
                                                <li>
                                                    <a href="javascript:;" data-action="4" class="tool-action">
                                                        <i class="icon-cloud-upload"></i> CSV</a>
                                                </li>
                                                <li class="divider"> </li>
                                                <li>
                                                    <a href="javascript:;" data-action="5" class="tool-action">
                                                        <i class="icon-refresh"></i> Reload</a>
                                                </li>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <div class="table-container">
                                        <h4 style="color:red;"><?php echo $msg; ?></h4>
                                        <table class="table table-striped table-bordered table-hover" id="sample_3">
                                            <thead>
                                                <tr class="poke">
                                                    <th>Plan</th>
                                                    <th>Menu Items</th>
                                                    <th>Submenu Items</th>
                                                    <th>Transaction Items</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $sql_query123 = "SELECT * FROM wms_plan ORDER by id";
                                                $result123 = mysqli_query($mycon, $sql_query123);
                                                $rows_total123 = mysqli_num_rows($result123);
                                                if (mysqli_num_rows($result123) > 0) {

                                                    while ($row = mysqli_fetch_assoc($result123)) {
                                                        //print_r($row);

                                                ?>
                                                        <tr>
                                                            <td><?php echo $row["plan"]; ?></td>
                                                            <td><?php echo $row["menu_items"]; ?></td>
                                                            <td><?php echo $row["submenu_items"]; ?></td>
                                                            <td><?php echo $row["transactions_items"]; ?></td>

                                                            <td><?php if ($row["status"] == 1) {
                                                                    echo 'Enabled';
                                                                } else if ($row["status"] == 0) {
                                                                    echo 'Disabled';
                                                                } ?></td>
                                                            <td>
                                                                <?php if ($row["status"] == 1) { ?>
                                                                    <label class="switch">
                                                                        <input id="chk1" value="<?php echo $row["id"]; ?>" onclick="disabledval('<?php echo $row["id"]; ?>','<?php echo $row["status"]; ?>')" type="checkbox" checked>
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                <?php } else if ($row["status"] == 0) { ?>

                                                                    <label class="switch">
                                                                        <input id="chk0" value="<?php echo $row["id"]; ?>" onclick="enabledval('<?php echo $row["id"]; ?>','<?php echo $row["status"]; ?>')" type="checkbox">
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                <?php  } ?>

                                                            </td>

                                                        </tr>
                                                <?php
                                                    }
                                                }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                            <!-- End: life time stats -->
                        </div>
                    </div>

                </div>
                <!-- END CONTENT BODY -->
            </div>
            <!-- END CONTENT -->
        </div>
        <!-- END CONTAINER -->
        <!--******* footer *******-->
        <footer class="global_footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12 text-center footer_copy_logo clearfix">
                        Copyright 2019-<?php echo date('Y'); ?> | Design & Develop By <?php echo $header_project_name; ?>

                    </div>
                </div>
            </div>
        </footer>
        <!--******* footer *******-->

    </div>

    <!-- Modal -->
    <div class="modal fade" id="myModal12233" role="dialog">
        <div class="modal-dialog modal-md">

            <!-- Modal content-->
            <div class="modal-content" style="">
                <div class="modal-header">
                    <h3 class="modal-title" id="lineModalLabel"></h3>
                    <i class="fa fa-times" data-dismiss="modal" aria-hidden="true"></i>

                </div>
                <div class="modal-body" id="vikas123">

                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" style="margin-top: 21px; visibility:hidden;">Close</button>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <?php include 'shared/footer.php'; ?>


    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="js/custom.js" type="text/javascript"></script>
    <script src="../assets/pages/scripts/components-select2.min.js" type="text/javascript"></script>

    <!-- END PAGE LEVEL SCRIPTS -->

    </script>
</body>

</html>