<?php
   require_once '../init.php';
   
   if (not_logged_in() === TRUE) {
      header('location: ../index.php');
   }
   
   $po_id = $_GET['d_id'];

   function get_po_details($id, $mycon)
   {
       $data_array = array();
       $sql_query = "SELECT * FROM `po_details` where id='" . $id . "'";
       $result = mysqli_query($mycon, $sql_query);
       if (mysqli_num_rows($result) > 0) {
           $row = mysqli_fetch_assoc($result);
           $data_array = $row;
           return  $data_array;
       }
   }
   $all_data = array();
   
   if ($po_id != '') {
       $all_data = get_po_details($po_id, $mycon);
   }

   function get_product_name($mycon, $product_code) {
      $sql_query = "SELECT `desc` FROM `material_master` WHERE part_no='" . $product_code . "' ";
      $result = mysqli_query($mycon, $sql_query);
      if (mysqli_num_rows($result) > 0) {
         $row = mysqli_fetch_assoc($result);
         $desc = $row['desc'];
      }
      return $desc;
   }
  
   function get_product($product, $mycon){
       $sql_query123 = "select mm.part_no, mm.desc as pro_desc FROM material_master as mm WHERE mm.part_no ='".$product."' limit 1";
       $result123 = mysqli_query($mycon,$sql_query123);
       if(mysqli_num_rows($result123) > 0){
           $rows123 = mysqli_fetch_assoc($result123);
           $product_code = $rows123['part_no'].'-'.$rows123['pro_desc'];
       } else {
           $product_code = $product;
       }
       return $product_code;
   }
?>
<!DOCTYPE html>
<html>
   <head>
      <meta charset="utf-8" />
      <title><?php echo $header_project_name; ?></title>
      <meta content="width=device-width, initial-scale=1" name="viewport" />
      <meta content="<?php echo $wmsData['about_wh']; ?>" name="description" />
      <meta content="Vikas Singh" name="author" />
      <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
      <link href="../assets/global/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
      <style type="text/css">
         body {
            font-family: "Open Sans", Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
         }
         .table th, .table td {
            border: 1px solid #000 !important;
            font-size: 12px;
            padding: 5px;
         }
         .table thead th {
            background: #e0e0e0 !important;
            color: #000;
            font-weight: bold;
            text-align: center;
         }
         .note {
            margin-bottom: 0.2rem;
            font-size: 11px;
         }
         .po-header {
            text-align: center;
            margin-bottom: 15px;
         }
         .po-header h4 {
            font-weight: bold;
            font-size: 16px;
            margin: 0;
         }
         address {
            margin-bottom: 5px;
         }
         .stamp-box {
            text-align: right;
         }
         @media print {
            .no-print, .page-footer, .page-sidebar, .quick-sidebar-wrapper {
               display: none !important;
            }
            body {
               margin: 0;
               padding: 0;
            }
            .container-fluid {
               width: 100%;
               margin: 0;
               padding: 0;
            }
         }
      </style>
   </head>
   <body onload="window.print()">
      <div class="wrapper">
         <div class="page-container">
            <section class="content">
               <div class="container-fluid">

                  <!-- Header -->
                  <div class="row">
                     <div class="col-md-2">
                        <img src="uploads/ClientLogo/<?php echo $wmsData['client_logo']; ?>" style="width:200px; height:60px;">
                     </div>
                     <div class="col-md-10 po-header">
                        <h4>Purchase Order</h4>
                     </div>
                  </div>

                  <!-- Bill To and PO -->
                  <div class="row" style="margin-top:10px;">
                     <div class="col-sm-6">
                        <b>Bill To</b>
                        <address>
                           <?php echo $all_data['billing_company_name'] ?><br />
                           <strong>Address:</strong> <?php echo $all_data['billing_address'] ?><br/>
                           <strong>GST:</strong> <?php echo $all_data['billing_gst'] ?><br />
                        </address>
                     </div>
                     <div class="col-sm-6 text-right">
                        <b style="font-size:16px">PO No: <?php echo $all_data['po_no']; ?></b> <br>
                        <b style="font-size:16px">Date: 
                        <?php 
                           $original_date = $all_data['po_date'];
                           $timestamp = strtotime($original_date);
                           echo date("d-m-Y", $timestamp); 
                        ?></b> <br>
                     </div>
                  </div>

                  <!-- Vendor and Delivery -->
                  <div class="row" style="margin-top:10px;">
                     <div class="col-sm-6">
                        <b>Vendor</b>
                        <address>
                           <?php echo $all_data['sender_name'] ?><br>
                           <strong>Address:</strong> <?php echo $all_data['sender_address1'] ?><br>
                           <strong>GST:</strong> <?php echo $all_data['gst_registration'] ?>
                        </address>
                     </div>
                     <div class="col-sm-6 text-right">
                        <b>Delivery At</b>
                        <address>
                           <?php echo $all_data['shipping_company_name'] ?><br />
                           <strong>Address:</strong> <?php echo $all_data['shipping_address'] ?><br />
                           <strong>GST:</strong> <?php echo $all_data['shipping_gst'] ?>
                        </address>
                     </div>
                  </div>

                  <!-- Order Scope + Table -->
                  <div class="row">
                     <div class="col-md-12 table-responsive">
                        <h6><b>Scope of Order :</b> <?php echo $all_data['scope_of_order'] ?></h6>
                        <table class="table table-bordered">
                           <thead>
                              <tr>
                                 <th>Item Description</th>
                                 <th>UOM</th>
                                 <th>PO QTY</th>
                                 <th>Unit Price</th>
                                 <th>GST %</th>
                                 <th>GST Amount</th>
                                 <th>Total Amount</th>
                              </tr>
                           </thead>
                           <tbody>
                              <?php
                                 $sql_query_fetch = "SELECT * FROM `po_material` WHERE po_id='".$po_id."'";
                                 // echo $sql_query_fetch;
                                 $result_fetch = mysqli_query($mycon, $sql_query_fetch);
                                 $subtotal_after_payment = 0;
                                 $gst_amount = 0;

                                 if (mysqli_num_rows($result_fetch) > 0) {
                                     while ($row = mysqli_fetch_assoc($result_fetch)) {
                                        $total_amount = $row['buying_price'] * $row['qty'];
                                        $subtotal_after_payment += $total_amount;
                                        $gst_amount += $row['gst_amount'];
                              ?>
                              <tr>
                                 <td><?php echo get_product($row['product_code'], $mycon); ?></td>
                                 <td><?php echo $row['uom']; ?></td>
                                 <td><?php echo $row['qty']; ?></td>
                                 <td><?php echo $row['buying_price']; ?></td>
                                 <td><?php echo $row['gst_tax_value']; ?></td>
                                 <td><?php echo $row['gst_amount']; ?></td>
                                 <td><?php echo $total_amount; ?></td>
                              </tr>
                              <?php
                                    }
                                 }
                              ?>
                              <tr>
                                 <th colspan="6" class="text-right">Subtotal:</th>
                                 <td><b>&#8377; <?php echo $subtotal_after_payment; ?></b></td>
                              </tr>
                              <tr>
                                 <th colspan="6" class="text-right">GST Amount:</th>
                                 <td><b>&#8377; <?php echo $gst_amount; ?></b></td>
                              </tr>
                              <tr>
                                 <th colspan="6" class="text-right">Grand Total:</th>
                                 <td><b>&#8377; <?php echo $subtotal_after_payment + $gst_amount; ?></b></td>
                              </tr>
                           </tbody>
                        </table>
                     </div>
                  </div>

                  <!-- Terms and Stamp -->
                  <div class="row" style="margin-top:20px;">
                     <div class="col-md-9">
                        <table class="table">
                           <tr><th>Terms & Conditions:-</th></tr>
                           <?php if ($all_data['taxes'] != '') { ?>
                           <tr><th>Taxes</th><td><?php echo $all_data['taxes']; ?></td></tr>
                           <?php } ?>
                           <?php if ($all_data['freight'] != '') { ?>
                           <tr><th>Freight</th><td><?php echo $all_data['freight']; ?></td></tr>
                           <?php } ?>
                           <?php if ($all_data['delivery'] != '') { ?>
                           <tr><th>Delivery</th><td><?php echo $all_data['delivery']; ?></td></tr>
                           <?php } ?>
                           <?php if ($all_data['payment'] != '') { ?>
                           <tr><th>Payment</th><td><?php echo $all_data['payment']; ?></td></tr>
                           <?php } ?>
                           <?php if ($all_data['penalty'] != '') { ?>
                           <tr><th>Penalty</th><td><?php echo $all_data['penalty']; ?></td></tr>
                           <?php } ?>
                        </table>
                     </div>
                     <div class="col-md-3 stamp-box">
                        <?php if($all_data['po_status'] == 1 || $all_data['po_status'] == 2 || $all_data['po_status'] == 5){ ?>
                           <img src="uploads/validation_pending.png" style="height: 100px; width: 160px;">
                        <?php } else if($all_data['po_status'] == 4 || $all_data['po_status'] == 7 || $all_data['po_status'] == 8) { ?>
                           <img src="uploads/approval_pending.png" style="height: 100px; width: 160px;">
                        <?php } else if($all_data['po_status'] == 3 || $all_data['po_status'] == 6 || $all_data['po_status'] == 9){ ?>
                           <img src="uploads/rejected.png" style="height: 100px; width: 160px;">
                        <?php } else { ?>
                           <img src="uploads/<?php echo $wmsData['client_stamp'];  ?>" style="height: 100px; width: 160px;">
                        <?php } ?>
                     </div>
                  </div>

                  <!-- Other Terms -->
                  <div class="row">
                     <div class="col-md-12">
                        <h6 style="font-weight: bold">Payment Terms</h6>
                        <p class="note">1. No Advance (Advance provided would be basis mutual understanding)</p>
                        <p class="note">2. 100% Against Running Invoice, 45 Days after invoice is been submitted and accepted.</p>
                        
                        <h6 style="font-weight: bold">Other Terms</h6>
                        <p class="note">1. Invoicing will be based on GRN Quantity</p>
                        <p class="note">2. All challans and bills must bear our purchase order number. Obtain receivers signatures and rubber stamp and attach it. </p>
                        <p class="note">3. The price stated on the PO is firm and includes all costs, including packaging, freight, insurance, and any applicable taxes, unless otherwise specified. </p>
                        <p class="note">4. Time is of the essence. Goods or services must be delivered on the date(s) specified in the PO. Late deliveries may result in order cancellation or penalties. </p>
                        <p class="note">5. Buyer reserves the right to modify or cancel the PO, in whole or in part, at any time prior to shipment or performance, without liability, unless the Supplier has incurred costs directly related to the order.</p>
                        <p class="note">6. All goods and services are subject to inspection and approval by the Buyer. The Buyer may reject any non-conforming goods/services and request replacement, repair, or refund at the Supplier’s expense.</p>
                        <p class="note">7. This PO is valid for 10 days after issuance of invoice </p>
                        <p class="note">8. Any arbitration would be settled within the jurisdiction of Mumbai </p>
                        <p class="note">9. We reserve the right to change the delivery address & Quantity</p>
                     </div>
                  </div>
               </div>
            </section>
         </div>
      </div>
   </body>
</html>
