<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
  header('location: ../index.php');
}

function get_available_qty($product_code, $mycon) {
  $tabledata = 0;
  $sql_query1 = "SELECT sum(quantity) AS available_qty FROM temp_split_quantity_putway WHERE product_code='" . $product_code . "' AND uploaded_confirmed = '0' group by product_code";

  $result1 = mysqli_query($mycon, $sql_query1);
  $rows_total1 = mysqli_num_rows($result1);
  if (mysqli_num_rows($result1) > 0) {
	while ($row1 = mysqli_fetch_assoc($result1)) {
	  $tabledata = $row1['available_qty'];
	}
  }
  return $tabledata;
}

function get_lockedqty($product_code, $mycon) {
  $total = 0;
  $sql_query = "SELECT SUM(pick_qty) AS qty FROM `picklist_generation` WHERE is_split = 0 AND pro_code='" . $product_code . "' group by pro_code";
  $result = mysqli_query($mycon, $sql_query);
  if (mysqli_num_rows($result) > 0) {
	while ($row = mysqli_fetch_assoc($result)) {
	  $total = $row['qty'];
	}
  }

  return $total;
}

function get_dispatched_qt($product_code, $mycon) {
  $total = 0;
  $sql_query = "SELECT SUM(picked_qt) AS qty FROM `packed_quantity_data` WHERE qa_status = 1 AND dispatched_auto_id = 0 AND product_code='" . $product_code . "' group by product_code";
  $result = mysqli_query($mycon, $sql_query);
  if (mysqli_num_rows($result) > 0) {
	while ($row = mysqli_fetch_assoc($result)) {
	  $total = $row['qty'];
	}
  }

  return $total;
}

function get_totalbatch($product_code, $mycon) {
  $total = 0;
  $sql_query2 = "SELECT * FROM temp_split_quantity_putway WHERE product_code='" . $product_code . "' group by relation_id";
  $result2 = mysqli_query($mycon, $sql_query2);
  $total2 = mysqli_num_rows($result2);

  $sql_query1 = "SELECT * FROM picklist_generation WHERE pro_code='" . $product_code . "' group by batch";
  $result1 = mysqli_query($mycon, $sql_query1);
  $total1 = mysqli_num_rows($result1);

  $total = $total2 + $total1;

  return $total;
}

function get_totallocation($product_code, $mycon) {
  $total1 = 0;
  $total2 = 0;
  $sql_query2 = "SELECT * FROM temp_split_quantity_putway WHERE product_code='" . $product_code . "' group by location";
  $result2 = mysqli_query($mycon, $sql_query2);
  $total2 = mysqli_num_rows($result2);

  $sql_query1 = "SELECT * FROM picklist_generation WHERE pro_code='" . $product_code . "' group by location";
  $result1 = mysqli_query($mycon, $sql_query1);
  $total1 = mysqli_num_rows($result1);

  $total = $total2 + $total1;

  return $total;
}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM `material_master` WHERE material_box_qty != 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by part_no DESC";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM `material_master` WHERE material_box_qty != 0 " . $role_item . "";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

  if (isset($_POST["page"])) {
	$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
	if (!is_numeric($page_number)) {
	  die('Invalid page number!');
	} //incase of invalid page number
  } else {
	$page_number = 1; //if there's no page number, set it to 1
  }

//Advance Search
  $startHour = "00:00:00";
  $endHour = "23:55:55";

  if ($_POST['item'] == 'part_no') {
	$srcitem = "AND part_no ='" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'desc') {
	$srcitem = "AND `desc` LIKE '%" . trim($_POST['colunmData']) . "%'";
  } else if ($_POST['item'] == 'all') {
	$srcitem = "";
  }

  //echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
  ?>
  <p class="details_table">
	  <?php
	  if ($_POST['item'] == '') {
		$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
		if ($is_defaultshowEntries > 20) {
		  $defaultshowEntries = 20;
		} else {
		  $defaultshowEntries = $is_defaultshowEntries;
		}
		?>
		<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
	  <?php } else { ?>
		<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
	  <?php } ?>
  </p>
  <table class="table table-striped table-bordered table-hover dataTable no-footer dtr-inline" id="sample_3" role="grid" aria-describedby="sample_3_info" style="width: 100%;">
  	<thead>
  	<thead>
  		<tr class="poke">
  			<th>Product Code</th>
  			<th>Product Description</th>
  			<!--<th>Binning Location </th>
  			<th>Total Batch</th>-->
  			<th>Available Qty</th>
  			<th>Locked Qty</th>
  			<th>Ready For Dispatch </th>
  			<th>Total Summary</th>

  		</tr>
  	</thead>
  </thead>
  <tbody>

	  <?php
	  $sql_query = "SELECT * FROM `material_master` WHERE material_box_qty != 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by part_no DESC";

	  $result123 = mysqli_query($mycon, $sql_query);
	  $get_total_rows = mysqli_num_rows($result123);
	  $total_pages = ceil($get_total_rows / $item_per_page);


//get starting position to fetch the records
	  $page_position = (($page_number - 1) * $item_per_page);

	  $sql_query_fetch = "SELECT * FROM `material_master` WHERE material_box_qty != 0 " . $srcitem . " " . $srcfrom . " " . $role_item . " order by part_no DESC LIMIT $page_position, $item_per_page";

	  $result_fetch = mysqli_query($mycon, $sql_query_fetch);
	  //echo '<br/>' . $sql_query_fetch;
	  //echo '<br/>' . $sql_query;
	  if (mysqli_num_rows($result_fetch) > 0) {
		while ($row = mysqli_fetch_assoc($result_fetch)) {
		  $available = get_available_qty($row['part_no'], $mycon);
		  $picklist_qty = get_lockedqty($row['part_no'], $mycon);
		  $dispatched_qty = get_dispatched_qt($row['part_no'], $mycon);
		  $total_summary = $available + $picklist_qty + $dispatched_qty;

		 // if ($total_summary != '' || $total_summary != 0) {
		  ?>
	  	<tr>
	  		<td> <?php echo $row['part_no']; ?></td>
	  		<td> <?php echo $row['desc']; ?></td>
	  					<!--<td><button class="btn btn-lg"  data-toggle="modal" data-target="#myModal12233" onclick="gradebatchNum('<?php echo $row['part_no']; ?>')"><?php echo get_totallocation($row['part_no'], $mycon); ?></button></td>
	  					<td><button class="btn btn-lg" data-toggle="modal" data-target="#myModal90" onclick="gradetProduct('<?php echo $row['part_no']; ?>')"> <?php echo get_totalbatch($row['part_no'], $mycon); ?> </button></td>-->
	  		<td> <?php echo $available; ?> </td>
	  		<td> <?php echo $picklist_qty; ?> </td>
	  		<td> <?php echo $dispatched_qty; ?> </td>
	  		<td> <?php echo $total_summary; ?> </td>
	  	</tr>
		  <?php
		  // }
		}
	  } else {
		?>
		<tr>
			<td><?php echo 'No Record Found'; ?></td>
		</tr>
	  <?php } ?>
  </tbody>
  </table>
  <div align="center">
	  <?php
	  /* We call the pagination function here to generate Pagination link for us.
	    As you can see I have passed several parameters to the function. */
	  echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
	  ?>
  </div>
  <?php
}
?>
</div>

