<?php
require_once '../../init.php';
require_once 'function.php';

if (not_logged_in() === TRUE) {
  header('location: ../index.php');
}


function get_dispatch_type($mycon, $dispatched_auto_id) {
  $sql_query = "SELECT dispatch_type FROM dispatch_log WHERE id='" . $dispatched_auto_id . "'";
  $result = mysqli_query($mycon, $sql_query);
  if (mysqli_num_rows($result) > 0) {

	while ($row = mysqli_fetch_assoc($result)) {
	  $dispatch_type = $row['dispatch_type'];
	}
  }
  if($dispatch_type == 0){ $dispatch_types = 'NA'; } else if($dispatch_type == 1){ $dispatch_types = 'Loaded the LR and Invoice with boxes'; } else if($dispatch_type == 2){ $dispatch_types = 'Loaded the LR and Invoice only'; }
  return $dispatch_types;
}

function get_data_invoice($mycon, $dispatched_auto_id, $outward_packing_box_id) {
  $invoice_number = array();
  $sql_query = "SELECT om.invoice_number, om.invoice_date, om.e_bill_date, om.e_bill_val FROM packed_quantity_data pqd join order_management om on om.order_id=pqd.order_id WHERE pqd.dispatched_auto_id='" . $dispatched_auto_id . "' AND pqd.outward_packing_box_id='" . $outward_packing_box_id . "' AND om.is_plan=0  AND om.order_status != 1  AND om.order_type != 1 group by om.invoice_number";


  $result = mysqli_query($mycon, $sql_query);
  $total_rows = mysqli_num_rows($result);
  if (mysqli_num_rows($result) > 0) {

	while ($row = mysqli_fetch_assoc($result)) {
	  $invoice_number[] = $row['invoice_number'];
	}
  }
  $invoice_numbers = implode(", ", $invoice_number);
  return $invoice_numbers;
}

function get_vehicle($mycon, $dispatched_auto_id) {
  $vehicleData = array();
  $sql_query = "SELECT scd_id FROM dispatch_log WHERE id='" . $dispatched_auto_id . "'";
  $result = mysqli_query($mycon, $sql_query);
  if (mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
	  $scd_id = $row['scd_id'];
	    $sql_query1 = "SELECT gate_pass_number, gate_entry_no FROM security_check_details WHERE id='" . $scd_id . "'";
		  $result1 = mysqli_query($mycon, $sql_query1);
		  if (mysqli_num_rows($result1) > 0) {
			while ($row1 = mysqli_fetch_assoc($result1)) {
			  $vehicleData['gate_pass_number'] = $row1['gate_pass_number'];
			  $vehicleData['gate_entry_no'] = $row1['gate_entry_no'];
			}
		  }	  
	   }
    }
  return $vehicleData;
}



function get_sale_delivery_data($mycon, $dispatched_auto_id, $outward_packing_box_id){
  
   $saleData = array();
  $sql_query = "SELECT om.ref_number,om.invoice_number,om.invoice_date,om.e_bill_val,om.e_bill_date FROM packed_quantity_data pqd, order_management om WHERE om.order_id=pqd.order_id AND pqd.dispatched_auto_id='" . $dispatched_auto_id . "' AND pqd.outward_packing_box_id='" . $outward_packing_box_id . "' AND om.is_plan=0 AND om.order_status != 1 group by pqd.dispatched_auto_id";
  $result = mysqli_query($mycon, $sql_query);
  if (mysqli_num_rows($result) > 0) {
    while ($row1 = mysqli_fetch_assoc($result)) {
	  $saleData['ref_number'] = $row1['ref_number'];
	  $saleData['invoice_number'] = $row1['invoice_number'];
	  $saleData['invoice_date'] = $row1['invoice_date'];
	  $saleData['e_bill_val'] = $row1['e_bill_val'];
	  $saleData['e_bill_date'] = $row1['e_bill_date'];
	      
	   }
    }
  return $saleData;
		}

// Search Data Show
function get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM packed_quantity_data WHERE lr_number_out<>'' " . $srcitem . " " . $srcfrom . " order by id DESC";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

function get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item) {
  $sql_query = "SELECT * FROM packed_quantity_data WHERE lr_number_out<>''" . $role_item . "";
  $result = mysqli_query($mycon, $sql_query);
  return mysqli_num_rows($result);
}

$item_per_page = 20;
//continue only if $_POST is set and it is a Ajax request
if (isset($_POST) && isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {

  if (isset($_POST["page"])) {
	$page_number = filter_var($_POST["page"], FILTER_SANITIZE_NUMBER_INT, FILTER_FLAG_STRIP_HIGH); //filter number
	if (!is_numeric($page_number)) {
	  die('Invalid page number!');
	} //incase of invalid page number
  } else {
	$page_number = 1; //if there's no page number, set it to 1
  }

//Advance Search
  $startHour = "00:00:00";
  $endHour = "23:55:55";

  if ($_POST['item'] == 'lr_number') {
	$srcitem = " AND lr_number_out = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'order_no') {
	$srcitem = " AND order_id = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'box_code') {
	$srcitem = " AND outward_packing_box_id = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'product_code') {
	$srcitem = " AND product_code = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'vehicle_number') {
	$srcitem = " AND vehicle_number = '" . trim($_POST['colunmData']) . "'";
  } else if ($_POST['item'] == 'transporter_name') {
	$srcitem = " AND transporter_name LIKE '%" . trim($_POST['colunmData']) . "%'";
  } else {
	$srcitem = "";
  }
  
  if ($_POST['disp_id'] != '') {
	$dispid = " AND dispatched_auto_id = '" . trim($_POST['disp_id']) . "'";
  } else {
	$dispid = "";
  }

  if ($_POST['todt'] != '') {
	$srcfrom = "AND dispatched_at BETWEEN '" . $_POST['fromdt'] . " $startHour' AND '" . $_POST['todt'] . " $endHour'";
  } else {
	$srcfrom = '';
  }


  //echo "colunmData--" . $_POST['colunmData'] . "<br/>fromdt--" . $_POST['fromdt'] . "<br/>todt--" . $_POST['todt'] . "<br/>item--" . $_POST['item'];
  ?>
  <p class="details_table">
	  <?php
	  if ($_POST['item'] == '') {
		$is_defaultshowEntries = get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item);
		if ($is_defaultshowEntries > 20) {
		  $defaultshowEntries = 20;
		} else {
		  $defaultshowEntries = $is_defaultshowEntries;
		}
		?>
		<span><b>Searched values : </b> Default Search</span> | <span>Showing <?php echo $defaultshowEntries; ?> by default of </span><span> <?php echo $is_defaultshowEntries; ?></span> <b> entries</b>
	  <?php } else { ?>
		<span><b>Searched values : </b> <?php echo $_POST['item'] . " - " . $_POST['colunmData']; ?></span> | <strong>Total Search Data: </strong> <span><?php echo get_all_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>| <span><b>Total No. of data :</b> <?php echo get_total_no_of_rows($mycon, $srcitem, $srcfrom, $role_item); ?></span>
	  <?php } ?>
  </p>
  <div style="overflow-x: scroll;">
  <table class="table table-striped table-bordered table-hover dataTable no-footer dtr-inline" id="sample_3" role="grid" aria-describedby="sample_3_info" style="width: 100%;">
  	<thead>
  	<thead>
  		<tr>
  			<th>Sales <br />Delivery <br />Number</th>
			<th>LR/Order Number</th>
			<th>Product Code</th>
			<th>Packed <br />Quantity</th>
			<th>Box Code</th>
			<th>UOM</th>
			<th>Packing <br />Configuration</th>
			<th>Packed-In</th>
			<th>Loose Qty</th>
			<th>E-Way Bill</th>
			<th>E-Way Bill<br />Date</th>
			<th>Dispatch <br />Invoice <br />Number</th>
			<th>Dispatch <br />Invoice <br />Date</th>
  			<th>Dispatch <br />Date</th>
  			<th>Vehicle <br />Number</th>
			<th>Vehicle <br />Gatepass</th>
			<th>Gate <br /> Entry <br />Note <br />Number </th>
  			<th>Transporter <br />Name</th>
			<th>Load <br />Type</th>
  		</tr>
  	</thead>
  </thead>
  <tbody>

	  <?php
	  //get total number of records from database for pagination
	  $i = 1;
	  $sql_query = "SELECT * FROM packed_quantity_data WHERE lr_number_out<>'' " . $dispid . " " . $srcitem . " " . $srcfrom . " " . $role_item . " group by dispatched_auto_id, outward_packing_box_id order by id DESC";

	  $result123 = mysqli_query($mycon, $sql_query);
	  $get_total_rows = mysqli_num_rows($result123);
	  $total_pages = ceil($get_total_rows / $item_per_page);


      //get starting position to fetch the records
	  $page_position = (($page_number - 1) * $item_per_page);

	   $sql_query_fetch = "SELECT *, SUM(picked_qt) as pickedqt FROM packed_quantity_data WHERE lr_number_out<>'' " . $dispid . " " . $srcitem . " " . $srcfrom . " " . $role_item . " group by dispatched_auto_id, outward_packing_box_id order by id DESC LIMIT $page_position, $item_per_page"; 

	  $result_fetch = mysqli_query($mycon, $sql_query_fetch);
	  // echo '<br/>' . $sql_query_fetch;
	  // echo '<br/>' . $sql_query;
	  if (mysqli_num_rows($result_fetch) > 0) {
		while ($row = mysqli_fetch_assoc($result_fetch)) {
			
			$dispatch_type = get_dispatch_type($mycon, $row['dispatched_auto_id']);
			
			$vehicle_data = get_vehicle($mycon, $row['dispatched_auto_id']);
			$sale_data = get_sale_delivery_data($mycon, $row['dispatched_auto_id'], $row['outward_packing_box_id']);
			
			$global_partdata = getmaterialBypartcode($row['product_code']);
				//partdesc,uom,category,moq,packing_configuration,packed_in
				//print_r($global_partdata);
				$packing_configuration = $global_partdata['packing_configuration'];
				$moq = $global_partdata['moq'];
				$packed_in = $global_partdata['packed_in'];
				$uom = $global_partdata['uom'];
				$x = $row['pickedqt'];
                $y = $moq;
                $loose  = fmod($x, $y);
				if($loose == 0 || $loose == ''){
					$loose_qty = 0;
				} else {
					$loose_qty = $loose." ".$uom;
				}
				$boxes  = ($x - $loose) / $y;
				$packedin_boxes = $boxes." ".$packed_in;
		  ?>
	  	<tr>
	  		
			
			<td><?php echo $sale_data['ref_number']; ?></td>
			<td><?php echo $row['lr_number_out']; ?></td>
	  		
			
	  		<td><?php echo $row['product_code']; ?></td>
			<td><?php echo $row['pickedqt']; ?></td>
			<td><?php echo $row['outward_packing_box_id']; ?></td>
			<td> <?php echo $uom; ?> </td>
			<td> <?php echo $packing_configuration; ?> </td>
			<td> <?php echo $packedin_boxes; ?> </td>
			<td> <?php echo $loose_qty; ?> </td>
			<td><?php echo $sale_data['e_bill_val']; ?></td>
			<td><?php echo $sale_data['e_bill_date']; ?></td>
	  		<td><?php echo $sale_data['invoice_number']; ?></td>
			<td><?php echo $sale_data['invoice_date']; ?></td>
	  		<td><?php echo $row['dispatched_at']; ?></td>
	  		<td><?php echo $row['vehicle_number']; ?></td>
			<td><?php echo $vehicle_data['gate_pass_number']; ?></td>
	  		<td><?php echo $vehicle_data['gate_entry_no']; ?></td>
	  		<td><?php echo $row['transporter_name']; ?></td>
			<td><?php echo $dispatch_type; ?></td>
	  	</tr>
		  <?php
		  $cnt++;
		}
	  } else {
		?>
		<tr>
			<td><?php echo 'No Record Found'; ?></td>
		</tr>
	  <?php } ?>
  </tbody>
  </table>
  </div>
  <div align="center">
	  <?php
	  /* We call the pagination function here to generate Pagination link for us.
	    As you can see I have passed several parameters to the function. */
	  echo paginate_function($item_per_page, $page_number, $get_total_rows, $total_pages);
	  ?>
  </div>
  <?php
}
?>
</div>

