<?php
require_once '../init.php';
include_once 'validate_input_funtion_special_chars_non_numbers.php';

if (not_logged_in() === TRUE) {
    header('location: ../index.php');
}

$today = date('Y-m-d H:i:s');


$filerefno = $_POST['file_ref_no'];

function check_ean($code_ril, $gnosis_pc, $mycon)
{
    $sql_query = "SELECT * FROM `customer_product_master_tbl` WHERE code_ril='$code_ril' AND gnosispc='$gnosis_pc'";
    $result = mysqli_query($mycon, $sql_query);
    return mysqli_num_rows($result) == 0; 
}

function check_validation_file_ref_number($filerefno, $mycon)
{
    $sql_query = "SELECT * FROM `customer_product_master_tbl` WHERE file_ref_num='$filerefno' AND uploaded_confirmed = 0";
    $result = mysqli_query($mycon, $sql_query);
    return mysqli_num_rows($result) == 0; 
}

if (!empty($_FILES["excel_file"])) {
    $file_array = explode(".", $_FILES["excel_file"]["name"]);
    if ($file_array[1] == "xls" || $file_array[1] == "xlsx") {
        include("PHPExcel/Classes/PHPExcel/IOFactory.php");

        $output = "<label class='text-success'>Data Inserted</label>
                   <div style='overflow-x:scroll'>
                   <table class='table table-sm table-nowrap table-bordered card-table'>
                   <thead>
                     <tr>
                             <th>Customer Name</th>
                             <th>Code Ril</th>
                             <th>GnosisPC</th>
                             <th>Item Category</th>
                             <th>Item Name</th>
                             <th>Item Name As per Gnosis</th>
                             <th>UOM</th>
                             <th>Cutting Requirement</th>
                             <th>File Ref No</th>
                             <th>Status</th>
                     </tr>
                   </thead>
                   <tbody>";

        $object = PHPExcel_IOFactory::load($_FILES["excel_file"]["tmp_name"]);
        $worksheet = $object->getSheet(0);
        $highestRow = $worksheet->getHighestRow();

        
        $headers = [
            "Customer Name", "Code Ril", "GnosisPC", "Item Category",
            "Item Name", "Item Name As per Gnosis", "UOM", "Cutting Requirement"
        ];

        for ($col = 0; $col < count($headers); $col++) {
            $header_val = trim($worksheet->getCellByColumnAndRow($col, 2)->getValue());
            if ($header_val !== $headers[$col]) {
                die("EXCEL header data does not correspond at column ".($col+1).": Expected '".$headers[$col]."' found '".$header_val."'");
            }
        }

        $total_data = $uploaded_data = $duplicate_data = 0;
        $file_duplicates = [];

        for ($row = 3; $row <= $highestRow; $row++) {

            $customer_name = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(0, $row)->getValue());
            $code_ril = mysqli_real_escape_string($mycon, $worksheet->getCellByColumnAndRow(1, $row)->getValue());
            $gnosis_pc = PHPExcel_Style_NumberFormat::toFormattedString($worksheet->getCellByColumnAndRow(2, $row)->getValue());
            $item_category = PHPExcel_Style_NumberFormat::toFormattedString($worksheet->getCellByColumnAndRow(3, $row)->getValue());
            $item_name = PHPExcel_Style_NumberFormat::toFormattedString($worksheet->getCellByColumnAndRow(4, $row)->getValue());
            $item_name_as_per_gnosis = PHPExcel_Style_NumberFormat::toFormattedString($worksheet->getCellByColumnAndRow(5, $row)->getValue());
            $uom = PHPExcel_Style_NumberFormat::toFormattedString($worksheet->getCellByColumnAndRow(6, $row)->getValue());
            $cutting_requirement = PHPExcel_Style_NumberFormat::toFormattedString($worksheet->getCellByColumnAndRow(7, $row)->getValue());

            $total_data++;

            
            $file_key = $code_ril . '_' . $gnosis_pc;
            $is_file_duplicate = in_array($file_key, $file_duplicates);
            $file_duplicates[] = $file_key;

            $is_db_duplicate = !check_ean($code_ril, $gnosis_pc, $mycon);
            $is_file_ref_valid = check_validation_file_ref_number($filerefno, $mycon);

            if ($code_ril == '' || $gnosis_pc == '') {
                $status = "Invalid Code Ril or GnosisPC";
                $duplicate_data++;
            } else if ($is_file_duplicate || $is_db_duplicate) {
                $status = "Duplicate Entry";
                $duplicate_data++;
            } else if (!$is_file_ref_valid) {
                $status = "Invalid File Ref No";
                $duplicate_data++;
            } else {
                $query = "INSERT INTO customer_product_master_tbl 
                    (user_id, warehouse_id, customer_name, code_ril, gnosispc, item_category, item_name, item_name_as_per_gnosis, uom, cutting_requirement, file_ref_num, uploaded_confirmed, created_at) 
                    VALUES ('$userid', '$warehouse_id', '$customer_name', '$code_ril', '$gnosis_pc', '$item_category', '$item_name', '$item_name_as_per_gnosis', '$uom', '$cutting_requirement', '$filerefno', 1, '$today')";
                
                $insert_data = mysqli_query($mycon, $query);
                $status = $insert_data ? "Uploaded" : "MySQL Error: " . mysqli_error($mycon);
                if ($insert_data) $uploaded_data++;
            }

            $output .= "<tr>
                            <td>{$customer_name}</td>
                            <td>{$code_ril}</td>
                            <td>{$gnosis_pc}</td>
                            <td>{$item_category}</td>
                            <td>{$item_name}</td>
                            <td>{$item_name_as_per_gnosis}</td>
                            <td>{$uom}</td>
                            <td>{$cutting_requirement}</td>
                            <td>{$filerefno}</td>
                            <td>{$status}</td>
                        </tr>";
        }

        $output .= "</tbody></table></div>";
        $final_output = "<b>Total Data:</b> {$total_data} | <b>Uploaded Data:</b> {$uploaded_data} | <b>Duplicate/Invalid Data:</b> {$duplicate_data}<br/><br/>" . $output;
        echo $final_output;
    } else {
        echo '<label class="text-danger">Invalid File</label>';
    }
}
?>
