<?php 
require_once '../init.php'; 
if (not_logged_in() === TRUE) { 
    header('location: ../index.php'); 
} 

$msg = "";
function check_is_updated($mycon, $order_id)
{
    $sql_query = "SELECT pod_dt FROM pod_mngt WHERE order_id = ?";
    $stmt = $mycon->prepare($sql_query);
    $stmt->bind_param("i", $order_id);
    $stmt->execute();
    $stmt->store_result();
    return $stmt->num_rows;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['pod_files'])) {
    $receiver_name = $_POST['receiver_name'];
    $receiver_phone = $_POST['receiver_phone'];
    $receiver_designation = $_POST['receiver_designation'];
    $remark = isset($_POST['remark']) ? $_POST['remark'] : '';
    $files = $_FILES['pod_files'];
    $upload_dir = "uploads/pod/";
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    for ($i = 0; $i < count($files['name']); $i++) {
        $original_name = $files['name'][$i];
        $tmp_name = $files['tmp_name'][$i];
        $ext = pathinfo($original_name, PATHINFO_EXTENSION);
        $order_id = pathinfo($original_name, PATHINFO_FILENAME); // filename = order_id
        if (!is_numeric($order_id)) {
            $msg .= "Invalid order ID in filename: $original_name<br>";
            continue;
        }
        if (strtolower($ext) !== 'pdf') {
            $msg .= "Only PDF files allowed: $original_name<br>";
            continue;
        }
        // Check if order_id exists
        $stmt = $mycon->prepare("SELECT order_id FROM order_management WHERE order_id = ?");
        $stmt->bind_param("i", $order_id);
        $stmt->execute();
        $res = $stmt->get_result();
        if ($res->num_rows === 0) {
            $msg .= "No order found for Order ID: $order_id<br>";
            continue;
        }
        // Save file
        $new_filename = $order_id . ".pdf";
        $target_path = $upload_dir . $new_filename;
        move_uploaded_file($tmp_name, $target_path);
        // Check if existing and insert or update
        $now = date("Y-m-d H:i:s");
        if (check_is_updated($mycon, $order_id)) {
            $sql = "UPDATE pod_mngt SET 
                        receiver_name = ?, 
                        receiver_phone = ?, 
                        receiver_designation = ?, 
                        remark = ?, 
                        uploaded_docs = ?, 
                        updated_at = ?
                    WHERE order_id = ?";
            $stmt = $mycon->prepare($sql);
            $stmt->bind_param("ssssssi", $receiver_name, $receiver_phone, $receiver_designation, $remark, $new_filename, $now, $order_id);
        } else {
            $sql = "INSERT INTO pod_mngt 
                        (user_id, warehouse_id, order_id, receiver_name, receiver_phone, receiver_designation, remark, uploaded_docs, pod_dt, updated_at) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $mycon->prepare($sql);
            $stmt->bind_param("iiisssssss", $user_id, $warehouse_id, $order_id, $receiver_name, $receiver_phone, $receiver_designation, $remark, $new_filename, $now, $now);
        }
        if ($stmt->execute()) {
            // Update delivery info
            $delivery_id = "SLL_D_" . time();
            $update_order = $mycon->prepare("UPDATE order_management SET is_delivered = 1, delivery_id = ?, delivered_end_at = ? WHERE order_id = ?");
            $update_order->bind_param("ssi", $delivery_id, $now, $order_id);
            $update_order->execute();
            $msg .= "POD processed for Order ID: $order_id<br>";
        } else {
            $msg .= "Database error for Order ID: $order_id<br>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title><?php echo $header_project_name; ?> - Bulk POD Upload</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include 'shared/header.php'; ?>

    <style>
        .form-horizontal {
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-top: 20px;
        }

        .form-column {
            padding: 0 15px;
        }

        .form-group label {
            font-weight: 600;
            color: #333;
        }

        .form-group input,
        .form-group textarea {
            background-color: #f9f9f9;
            border: 1px solid #ccc !important;
        }

        .btn-success {
            padding: 10px 30px;
            font-size: 16px;
            font-weight: 600;
        }

        .alert {
            margin-top: 20px;
        }

        .form-control {
            width: 98%;
        }

        .top-right-btn {
            display: flex;
            justify-content: flex-end;
            margin-bottom: -10px;
        }

        .page-content {
            margin-top: 30px !important;
        }
    </style>
</head>

<body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white page-sidebar-closed page-md">
    <div class="page-wrapper">
        <?php include 'top_menu.php'; ?>
        <div class="clearfix"></div>

        <div class="page-container">
            <?php include 'sidebar.php'; ?>

            <div class="page-content-wrapper">
                <div class="page-content">
                    <div class="top-right-btn" style="margin-top: -45px;">
                        <a href="proof-of-delivery.php">
                            <button type="button" class="btn btn-info">Back</button>
                        </a>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <form method="POST" enctype="multipart/form-data" class="form-horizontal">
                                <div class="form-body">
                                    <h4 class="form-section">Upload POD Details</h4>
                                    <div class="row">
                                        <!-- Left column -->
                                        <div class="col-md-6 form-column">
                                            <div class="form-group">
                                                <label for="receiver_name">Receiver Name <span class="text-danger">*</span></label>
                                                <input type="text" name="receiver_name" class="form-control" required />
                                            </div>

                                            <div class="form-group">
                                                <label for="receiver_phone">Receiver Phone <span class="text-danger">*</span></label>
                                                <input type="text" name="receiver_phone" class="form-control" onkeypress="return onlyNos(event);" required />
                                            </div>

                                            <div class="form-group">
                                                <label for="receiver_designation">Receiver Designation <span class="text-danger">*</span></label>
                                                <input type="text" name="receiver_designation" class="form-control" required />
                                            </div>
                                        </div>

                                        <!-- Right column -->
                                        <div class="col-md-6 form-column">
                                            <div class="form-group">
                                                <label for="remark">Remark (optional)</label>
                                                <textarea name="remark" class="form-control" rows="4"></textarea>
                                            </div>

                                            <div class="form-group">
                                                <label for="pod_files" style="margin-top: 14px;">Select PDF Files <span class="text-danger">*</span></label>
                                                <input type="file" name="pod_files[]" class="form-control" multiple accept="application/pdf" required />
                                                <small class="form-text text-muted">Ensure filenames match their respective order IDs.</small>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-actions text-right">
                                        <button type="submit" class="btn btn-success">Upload PODs</button>
                                    </div>
                                </div>
                            </form>

                            <?php if (!empty($msg)): ?>
                                <div class="alert alert-info"><?php echo $msg; ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include 'shared/footer.php'; ?>
    </div>

    <script>
        function onlyNos(e) {
            var charCode = e.which || e.keyCode;
            if (charCode > 31 && (charCode < 48 || charCode > 57)) {
                alert("Only numbers are allowed.");
                return false;
            }
            return true;
        }
    </script>
</body>
</html>
