<?php
require_once '../init.php';

if (not_logged_in() === true) {
   header('Location: ../index.php');
   exit();
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
   <meta charset="utf-8" />
   <title><?php echo htmlspecialchars($header_project_name); ?></title>
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta content="width=device-width, initial-scale=1" name="viewport" />
   <meta content="<?php echo htmlspecialchars($wmsData['about_wh']); ?>" name="description" />
   <meta content="Vikas Singh" name="author" />
   <?php include 'shared/header.php'; ?>
   <script src="common_validation/material_master_validation.js" type="text/javascript"></script>
   <script src="../assets/global/scripts/jquery.min.js"></script>
   <style>
      label {
         font-weight: 600;
         position: absolute;
      }

      .chosen-container-single .chosen-single {
         position: relative;
         display: inline-block;
         vertical-align: middle;
         width: 470px !important;
         font-size: 13px;
         -webkit-user-select: none;
         -moz-user-select: none;
         user-select: none;
      }

      .chosen-container .chosen-drop {
         width: 470px !important;
      }
   </style>
</head>

<body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white page-sidebar-closed page-md">
   <div class="page-wrapper">
      <?php include 'top_menu.php'; ?>
      <div class="clearfix"></div>
      <div class="page-container">
         <?php include 'sidebar.php'; ?>
         <div class="page-content-wrapper">
            <div class="page-content">
               <div class="row">
                  <div class="col-md-12 position-relative table_header" style="height: 50px;">
                     <h3 class="text-center" style="margin: 0; position: absolute; left: 50%; transform: translateX(-50%);">Add Gross GRN</h3>
                     <a href="pending_grn.php" style="position: absolute; right: 0;">
                        <button type="button" class="btn btn-info">Back</button>
                     </a>
                  </div>
                  <div class="col-md-12">
                     <div class="row">
                        <h5 style="margin-left: 15px; font-weight:bold"><u>Vehicle Details :- </u></h5>
                        <div class="col-md-3">
                           <div class="form-group form-md-line-input form-md-floating-label has-success">
                              <label for="vehicle_no" class="poke8">Vehicle No&#9733;</label>
                              <input type="text" name="vehicle_no" id="vehicle_no" class="form-control">
                           </div>
                           <span class="error" style="display: none;" id="error_vehicle_no">
                              <p class="text-danger">This Field cannot be left Empty*</p>
                           </span>
                        </div>
                        <div class="col-md-3">
                           <div class="form-group form-md-line-input form-md-floating-label has-success">
                              <label for="gate_entry_no" class="poke8">Gate Entry No.&#9733;</label>
                              <input type="text" name="gate_entry_no" id="gate_entry_no" class="form-control">
                           </div>
                           <span class="error" style="display: none;" id="error_gate_entry_no">
                              <p class="text-danger">This Field cannot be left Empty*</p>
                           </span>
                        </div>
                        <div class="col-md-3">
                           <div class="form-group form-md-line-input form-md-floating-label has-success">
                              <label for="transporter_name" class="poke8">Transporter Name.&#9733;</label>
                              <input type="text" name="transporter_name" id="transporter_name" class="form-control">
                           </div>
                           <span class="error" style="display: none;" id="error_transporter_name">
                              <p class="text-danger">This Field cannot be left Empty*</p>
                           </span>
                        </div>
                     </div>
                     <div class="row">
                        <h5 style="margin-left: 15px; font-weight:bold"><u>Vendor PO Details :- </u></h5>
                        <div class="col-md-3">
                           <div class="form-group form-md-line-input form-md-floating-label has-success">
                              <label for="invoice_challan_po" class="poke8">Invoice/Challan No.&#9733;</label>
                              <select id="invoice_challan_po" class="form-control" onchange="GetChallanData()">
                                 <option value="">Select Invoice/Challan No.</option>
                                 <?php
                                 $sql_query = "SELECT id, challan_no FROM `vendor_challan_tbl` GROUP BY challan_no";
                                 $result = mysqli_query($mycon, $sql_query);
                                 if ($result && mysqli_num_rows($result) > 0) {
                                    while ($row = mysqli_fetch_assoc($result)) {
                                 ?>
                                       <option value="<?php echo $row['challan_no']; ?>">
                                          <?php echo $row['challan_no']; ?>
                                       </option>
                                 <?php
                                    }
                                 }
                                 ?>
                              </select>
                           </div>
                           <span class="error" style="display: none;" id="error_invoice_challan_po">
                              <p class="text-danger">This Field cannot be left Empty*</p>
                           </span>
                        </div>

                        <div class="col-md-3">
                           <div class="form-group form-md-line-input form-md-floating-label has-success">
                              <label for="supplier_name" class="poke8">Supplier Name &#9733;</label>
                              <input type="text" id="supplier_name" name="supplier_name" class="form-control" readonly>
                           </div>
                           <span class="error" style="display: none;" id="error_supplier_name">
                              <p class="text-danger">This Field cannot be left Empty*</p>
                           </span>
                        </div>

                        <div class="col-md-3">
                           <div class="form-group form-md-line-input form-md-floating-label has-success">
                              <label for="po_no" class="poke8">PO No.&#9733;</label>
                              <input type="text" id="po_no" class="form-control" readonly>
                           </div>
                           <span class="error" style="display: none;" id="error_po_no">
                              <p class="text-danger">This Field cannot be left Empty*</p>
                           </span>
                        </div>


                        <div class="col-md-3">
                           <div class="form-group form-md-line-input form-md-floating-label has-success">
                              <label for="invoice_challan_po" class="poke8">Total Challan Qty.&#9733;</label>
                              <input type="text" id="challan_qty" class="form-control" readonly>
                           </div>
                           <span class="error" style="display: none;" id="error_invoice_challan_po">
                              <p class="text-danger">This Field cannot be left Empty*</p>
                           </span>
                        </div>
                     </div>


                     <div class="row mt-3">
                        <div class="col-md-12" id="challanTableContainer"></div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
   <footer class="global_footer">
      <div class="container-fluid">
         <div class="row" style="overflow: hidden;">
            <div class="col-sm-6 footer_copy_logo clearfix">
               Copyright 2019-<?php echo date('Y'); ?> | Design & Develop By <?php echo htmlspecialchars($header_project_name); ?>
            </div>
            <div class="logo_foot col-md-4 text-right">
               <a href="#"><img src="../assets/layouts/layout/img/logo.png" alt="logo" class="logo-default" style="max-width: 145px;object-fit: cover;"></a>
            </div>
         </div>
      </div>
   </footer>
   </div>

   <script>
      function GetChallanData() {
         var challanId = $('#invoice_challan_po').val();
         if (challanId === '') {
            $('#challan_qty').val('');
            $('#challanTableContainer').html('');
            return;
         }

         $.ajax({
            url: 'get_all_product_details.php',
            type: 'POST',
            data: {
               id: challanId
            },
            dataType: 'json',
            success: function(response) {
               $('#challan_qty').val(response.challan_qty);
               $('#po_no').val(response.po_no);
               $('#supplier_name').val(response.supplier_name);
               $('#challanTableContainer').html(response.table_html);

            }
         });
      }
   </script>


   <!-- 
   <script>
      function GetPOforSupplier() {
         var supplier = $('#supplier_name').val();
         $('#po_no').html('<option value="">Select PO</option>');
         $('#invoice_challan_po').html('<option value="">Select Challan</option>');
         $('#challan_qty').val('');
         $('#challanTableContainer').html('');

         if (supplier !== '') {
            $.ajax({
               url: 'get_po_for_supplier.php',
               type: 'POST',
               data: {
                  supplier: supplier
               },
               dataType: 'json',
               success: function(data) {
                  $.each(data, function(i, po) {
                     $('#po_no').append('<option value="' + po.id + '">' + po.po_no + '</option>');
                     $('#invoice_challan_po').append('<option value="' + po.id + '">' + po.challan_no + '</option>');
                  });
               }
            });
         }
      }

      function GetChallanData() {
         var challanId = $('#invoice_challan_po').val();
         if (challanId === '') {
            $('#challan_qty').val('');
            $('#challanTableContainer').html('');
            return;
         }

         $.ajax({
            url: 'get_all_product_details.php',
            type: 'POST',
            data: {
               id: challanId
            },
            dataType: 'json',
            success: function(response) {
               $('#challan_qty').val(response.challan_qty);
               $('#challanTableContainer').html(response.table_html);
            }
         });
      }
   </script> -->

   <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
   <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
   <script type="text/javascript">
      $(document).ready(function() {
         $('#company_name').click(function() {
            // The original lines were setting values back to themselves; this snippet does nothing meaningful and is removed.
            // If you want to copy values or do something else, please define it here.
         });
      });
   </script>
   <script src="js/choosen.js"></script>
   <script type="text/javascript">
      $(".chosen").chosen();
   </script>

   <?php if ($edit == '1') { ?>
      <script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
      <script type="text/javascript">
         $(document).ready(function() {
            $("#form_add :input").prop("disabled", true);
         });
      </script>
   <?php } ?>
</body>

</html>
<?php ob_end_flush(); ?>